/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gadgets;

import forestry.api.apiculture.IAlvearyComponent;
import forestry.api.core.ITileStructure;
import forestry.apiculture.gadgets.TileAlvearyPlain;
import forestry.core.config.ForestryBlock;
import forestry.core.gadgets.BlockStructure;
import forestry.core.gadgets.StructureLogic;
import forestry.core.utils.Schemata;
import forestry.core.utils.Vect;
import java.util.ArrayList;
import java.util.Arrays;

public class StructureLogicAlveary
extends StructureLogic {
    public static final String UID_ALVEARY = "alveary";
    public static final Schemata SCHEMATA_ALVEARY = new Schemata("alveary3x3", 5, 6, 5, "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FAAAF", "FAAAF", "FABAF", "FCCCF", "FFFFF", "FFFFF", "FAAAF", "FAAAF", "FBMBF", "FCCCF", "FFFFF", "FFFFF", "FAAAF", "FAAAF", "FABAF", "FCCCF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF").setOffsets(-2, -3, -2);
    public static final ArrayList slabIds = new ArrayList(Arrays.asList(new int[][]{{amq.an.cm, amq.bR.cm}}));

    public StructureLogicAlveary(ITileStructure structure) {
        super(UID_ALVEARY, structure);
        this.schematas = new Schemata[]{SCHEMATA_ALVEARY};
        this.metaOnValid.put(Schemata.EnumStructureBlock.BLOCK_B, 1);
    }

    @Override
    protected BlockStructure.EnumStructureState determineMasterState(Schemata schemata, boolean rotate) {
        Vect dimensions = schemata.getDimensions(rotate);
        int offsetX = schemata.getxOffset();
        int offsetZ = schemata.getzOffset();
        if (rotate) {
            offsetX = schemata.getzOffset();
            offsetZ = schemata.getxOffset();
        }
        for (int i = 0; i < dimensions.x; ++i) {
            for (int j = 0; j < schemata.getHeight(); ++j) {
                block10: for (int k = 0; k < dimensions.z; ++k) {
                    int z;
                    int x = this.structureTile.l + i + offsetX;
                    int y2 = this.structureTile.m + j + schemata.getyOffset();
                    if (!this.structureTile.k.f(x, y2, z = this.structureTile.n + k + offsetZ)) {
                        return BlockStructure.EnumStructureState.INDETERMINATE;
                    }
                    Schemata.EnumStructureBlock required = schemata.getAt(i, j, k, rotate);
                    if (required == Schemata.EnumStructureBlock.ANY) continue;
                    any tile = this.structureTile.k.q(x, y2, z);
                    int blockid = this.structureTile.k.a(x, y2, z);
                    switch (required) {
                        case AIR: {
                            if (blockid == 0) continue block10;
                            return BlockStructure.EnumStructureState.INVALID;
                        }
                        case BLOCK_A: {
                            if (tile == null || !(tile instanceof IAlvearyComponent)) {
                                return BlockStructure.EnumStructureState.INVALID;
                            }
                            if (((ITileStructure)tile).getTypeUID().equals(UID_ALVEARY)) continue block10;
                            return BlockStructure.EnumStructureState.INVALID;
                        }
                        case MASTER: 
                        case BLOCK_B: {
                            if (tile != null && tile instanceof TileAlvearyPlain) continue block10;
                            return BlockStructure.EnumStructureState.INVALID;
                        }
                        case BLOCK_C: {
                            if (blockid != amq.an.cm && blockid != amq.bR.cm && blockid != ForestryBlock.slabs1.cm && blockid != ForestryBlock.slabs2.cm) {
                                return BlockStructure.EnumStructureState.INVALID;
                            }
                            if ((this.structureTile.k.h(x, y2, z) & 8) == 0) continue block10;
                            return BlockStructure.EnumStructureState.INVALID;
                        }
                        case BLOCK_D: {
                            if (blockid == amq.bZ.cm) continue block10;
                            return BlockStructure.EnumStructureState.INVALID;
                        }
                        case FOREIGN: {
                            if (!(tile instanceof ITileStructure)) continue block10;
                            return BlockStructure.EnumStructureState.INVALID;
                        }
                        default: {
                            return BlockStructure.EnumStructureState.INDETERMINATE;
                        }
                    }
                }
            }
        }
        return BlockStructure.EnumStructureState.VALID;
    }
}

