/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gadgets;

import forestry.api.apiculture.IAlvearyComponent;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.core.IStructureLogic;
import forestry.api.core.ITileStructure;
import forestry.apiculture.gadgets.StructureLogicAlveary;
import forestry.core.config.ForestryBlock;
import forestry.core.gadgets.Gadget;
import forestry.core.gadgets.TileForestry;
import forestry.core.network.PacketPayload;
import forestry.core.proxy.Proxies;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.TileInventoryAdapter;
import forestry.core.utils.Utils;
import java.util.LinkedList;

public abstract class TileAlveary
extends TileForestry
implements IAlvearyComponent {
    protected TileInventoryAdapter inventory;
    protected final int componentBlockMeta;
    IStructureLogic structureLogic = new StructureLogicAlveary(this);
    private boolean isMaster;
    protected int masterX;
    protected int masterZ;
    protected int masterY = -99;

    public TileAlveary(int componentBlockMeta) {
        this.componentBlockMeta = componentBlockMeta;
    }

    @Override
    public void initialize() {
        int blockid = this.k.a(this.l, this.m, this.n);
        if (blockid != ForestryBlock.alveary.cm) {
            Proxies.log.info("Updating alveary block at %s/%s/%s.", this.l, this.m, this.n);
            this.k.c(this.l, this.m, this.n, ForestryBlock.alveary.cm, this.componentBlockMeta);
            this.s();
            this.k.a(this.l, this.m, this.n, (any)this);
        }
    }

    @Override
    public void g() {
        if (!Proxies.common.isSimulating(this.k)) {
            this.updateClientSide();
        } else {
            if (!this.isInited) {
                this.initialize();
                this.isInited = true;
            }
            if (this.k.G() % 200L == 0L && (!this.isIntegratedIntoStructure() || this.isMaster())) {
                this.validateStructure();
            }
            this.updateServerSide();
        }
    }

    protected void updateServerSide() {
    }

    protected void updateClientSide() {
    }

    public int getBlockTexture(int side, int metadata) {
        return 25;
    }

    @Override
    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        this.isMaster = nbttagcompound.n("IsMaster");
        this.masterX = nbttagcompound.e("MasterX");
        this.masterY = nbttagcompound.e("MasterY");
        this.masterZ = nbttagcompound.e("MasterZ");
        if (this.isMaster) {
            this.makeMaster();
        }
        this.structureLogic.readFromNBT(nbttagcompound);
    }

    @Override
    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("IsMaster", this.isMaster);
        nbttagcompound.a("MasterX", this.masterX);
        nbttagcompound.a("MasterY", this.masterY);
        nbttagcompound.a("MasterZ", this.masterZ);
        this.structureLogic.writeToNBT(nbttagcompound);
    }

    protected void createInventory() {
        this.inventory = new TileInventoryAdapter(this, 9, "Items");
    }

    @Override
    public Gadget getMachine() {
        return null;
    }

    @Override
    public void fromPacketPayload(PacketPayload payload) {
    }

    @Override
    public PacketPayload getPacketPayload() {
        return null;
    }

    @Override
    public String getTypeUID() {
        return this.structureLogic.getTypeUID();
    }

    @Override
    public void validateStructure() {
        this.structureLogic.validateStructure();
    }

    @Override
    public void makeMaster() {
        this.setCentralTE(null);
        this.isMaster = true;
        if (this.inventory == null) {
            this.createInventory();
        }
    }

    @Override
    public void onStructureReset() {
        this.setCentralTE(null);
        if (this.k.h(this.l, this.m, this.n) == 1) {
            this.k.d(this.l, this.m, this.n, 0);
        }
        this.isMaster = false;
        this.k.i(this.l, this.m, this.n);
    }

    @Override
    public ITileStructure getCentralTE() {
        if (!this.isIntegratedIntoStructure()) {
            return null;
        }
        if (!this.isMaster()) {
            any tile = this.k.q(this.masterX, this.masterY, this.masterZ);
            if (tile instanceof ITileStructure) {
                ITileStructure master = (ITileStructure)this.k.q(this.masterX, this.masterY, this.masterZ);
                if (master.isMaster()) {
                    return master;
                }
                return null;
            }
            return null;
        }
        return this;
    }

    private boolean isSameTile(any tile) {
        return tile.l == this.l && tile.m == this.m && tile.n == this.n;
    }

    @Override
    public void setCentralTE(any tile) {
        if (tile == null || tile == this || this.isSameTile(tile)) {
            this.masterZ = 0;
            this.masterX = 0;
            this.masterY = -99;
            return;
        }
        this.isMaster = false;
        this.masterX = tile.l;
        this.masterY = tile.m;
        this.masterZ = tile.n;
    }

    @Override
    public boolean isMaster() {
        return this.isMaster;
    }

    protected boolean hasMaster() {
        return this.masterY >= 0;
    }

    @Override
    public boolean isIntegratedIntoStructure() {
        return this.isMaster || this.masterY >= 0;
    }

    @Override
    public la getInventory() {
        return this.inventory;
    }

    @Override
    public boolean hasFunction() {
        return false;
    }

    @Override
    public void addTemperatureChange(float change, float boundaryDown, float boundaryUp) {
    }

    @Override
    public void addHumidityChange(float change, float boundaryDown, float boundaryUp) {
    }

    @Override
    public void registerBeeModifier(IBeeModifier modifier) {
    }

    @Override
    public void removeBeeModifier(IBeeModifier modifier) {
    }

    @Override
    public void registerBeeListener(IBeeListener event) {
    }

    @Override
    public void removeBeeListener(IBeeListener event) {
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.missingQueen);
        res.add(ForestryTrigger.missingDrone);
        return res;
    }

    @Override
    public boolean a_(qx player) {
        return Utils.isUseableByPlayer(player, this, this.k, this.l, this.m, this.n);
    }
}

