/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gadgets;

import buildcraft.api.inventory.ISpecialInventory;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ForestryAPI;
import forestry.api.core.ITileStructure;
import forestry.apiculture.gadgets.TileAlveary;
import forestry.apiculture.gui.ContainerAlveary;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.genetics.ClimateHelper;
import forestry.core.interfaces.IClimatised;
import forestry.core.interfaces.IErrorSource;
import forestry.core.interfaces.IHintSource;
import forestry.core.network.GuiId;
import forestry.core.network.PacketInventoryStack;
import forestry.core.proxy.Proxies;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

public class TileAlvearyPlain
extends TileAlveary
implements ISpecialInventory,
ISidedInventory,
IBeeHousing,
IClimatised,
IHintSource {
    public static final int SLOT_QUEEN = 0;
    public static final int SLOT_DRONE = 1;
    public static final int SLOT_PRODUCT_1 = 2;
    public static final int SLOT_PRODUCTION_COUNT = 7;
    protected IBeekeepingLogic beekeepingLogic;
    protected int biomeId;
    protected float temperature;
    protected float humidity;
    protected float tempChange = 0.0f;
    protected float humidChange = 0.0f;
    private int displayHealthMax = 0;
    private int displayHealth = 0;
    private Set modifiers = new LinkedHashSet();
    private Set eventHandlers = new LinkedHashSet();

    public TileAlvearyPlain() {
        super(0);
    }

    @Override
    public void openGui(qx player) {
        if (this.isMaster()) {
            player.openGui(ForestryAPI.instance, GuiId.AlvearyGUI.ordinal(), this.k, this.l, this.m, this.n);
        } else if (this.hasMaster()) {
            player.openGui(ForestryAPI.instance, GuiId.AlvearyGUI.ordinal(), this.k, this.masterX, this.masterY, this.masterZ);
        }
    }

    @Override
    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        this.tempChange = nbttagcompound.g("TempChange");
        this.humidChange = nbttagcompound.g("HumidChange");
        if (this.inventory != null) {
            this.inventory.readFromNBT(nbttagcompound);
        }
        if (this.beekeepingLogic != null) {
            this.beekeepingLogic.readFromNBT(nbttagcompound);
        }
    }

    @Override
    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("TempChange", this.tempChange);
        nbttagcompound.a("HumidChange", this.humidChange);
        if (this.inventory != null) {
            this.inventory.writeToNBT(nbttagcompound);
        }
        if (this.beekeepingLogic != null) {
            this.beekeepingLogic.writeToNBT(nbttagcompound);
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        yy biome = this.k.a(this.l, this.n);
        this.biomeId = biome.N;
        this.temperature = biome.F;
        this.humidity = biome.G;
        this.setErrorState(EnumErrorCode.OK);
    }

    @Override
    protected void updateServerSide() {
        if (this.beekeepingLogic == null) {
            return;
        }
        if (!this.isMaster()) {
            return;
        }
        this.beekeepingLogic.update();
        this.equalizeTemperature();
        this.equalizeHumidity();
        IBee queen = this.beekeepingLogic.getQueen();
        if (queen == null) {
            return;
        }
        if (this.k.G() % 200L * 10L == 0L) {
            this.onQueenChange(this.inventory.a(0));
        }
        if (this.getErrorState() == EnumErrorCode.OK) {
            queen.doFX(this.beekeepingLogic.getEffectData(), this);
        }
        if (this.getErrorState() == EnumErrorCode.OK && this.k.G() % 50L == 0L) {
            float f = (float)this.l + 0.5f;
            float f1 = (float)this.m + 0.0f + this.k.t.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)this.n + 0.5f;
            float f3 = 0.52f;
            float f4 = this.k.t.nextFloat() * 0.6f - 0.3f;
            Proxies.common.addEntitySwarmFX(this.k, f - f3, f1, f2 + f4, 0.0f, 0.0f, 0.0f);
            Proxies.common.addEntitySwarmFX(this.k, f + f3, f1, f2 + f4, 0.0f, 0.0f, 0.0f);
            Proxies.common.addEntitySwarmFX(this.k, f + f4, f1, f2 - f3, 0.0f, 0.0f, 0.0f);
            Proxies.common.addEntitySwarmFX(this.k, f + f4, f1, f2 + f3, 0.0f, 0.0f, 0.0f);
        }
    }

    @Override
    protected void updateClientSide() {
        if (!this.isMaster()) {
            return;
        }
        if (this.inventory == null) {
            return;
        }
        if (BeeManager.beeInterface.isMated(this.inventory.a(0)) && this.getErrorState() == EnumErrorCode.OK && this.k.G() % 2L == 0L) {
            IBee displayQueen = BeeManager.beeInterface.getBee(this.inventory.a(0));
            displayQueen.doFX(this.beekeepingLogic.getEffectData(), this);
        }
    }

    private void equalizeTemperature() {
        if (this.tempChange == 0.0f) {
            return;
        }
        this.tempChange -= 0.05f * this.tempChange;
        if (this.tempChange <= 0.001f && this.tempChange >= -0.001f) {
            this.tempChange = 0.0f;
        }
    }

    private void equalizeHumidity() {
        if (this.humidChange == 0.0f) {
            return;
        }
        this.humidChange -= 0.05f * this.humidChange;
        if (this.humidChange <= 0.001f && this.humidChange >= 0.001f) {
            this.humidChange = 0.0f;
        }
    }

    private int getHealthDisplay() {
        if (this.inventory == null || this.inventory.a(0) == null) {
            return 0;
        }
        if (BeeManager.beeInterface.isMated(this.inventory.a(0))) {
            return BeeManager.beeInterface.getBee(this.inventory.a(0)).getHealth();
        }
        if (!BeeManager.beeInterface.isDrone(this.inventory.a(0))) {
            return this.displayHealth;
        }
        return 0;
    }

    private int getMaxHealthDisplay() {
        if (this.inventory == null || this.inventory.a(0) == null) {
            return 0;
        }
        if (BeeManager.beeInterface.isMated(this.inventory.a(0))) {
            return BeeManager.beeInterface.getBee(this.inventory.a(0)).getMaxHealth();
        }
        if (!BeeManager.beeInterface.isDrone(this.inventory.a(0))) {
            return this.displayHealthMax;
        }
        return 0;
    }

    public int getHealthScaled(int i) {
        if (this.getMaxHealthDisplay() == 0) {
            return 0;
        }
        return this.getHealthDisplay() * i / this.getMaxHealthDisplay();
    }

    @Override
    public boolean allowsInteraction(qx player) {
        if (!super.allowsInteraction(player)) {
            return false;
        }
        return this.isIntegratedIntoStructure();
    }

    @Override
    public void makeMaster() {
        super.makeMaster();
        if (this.beekeepingLogic == null) {
            this.beekeepingLogic = BeeManager.breedingManager.createBeekeepingLogic(this);
        }
    }

    @Override
    public void onStructureReset() {
        super.onStructureReset();
        this.modifiers.clear();
        this.eventHandlers.clear();
    }

    @Override
    public void registerBeeModifier(IBeeModifier modifier) {
        this.modifiers.add(modifier);
    }

    @Override
    public void removeBeeModifier(IBeeModifier modifier) {
        this.modifiers.remove(modifier);
    }

    @Override
    public void registerBeeListener(IBeeListener modifier) {
        this.eventHandlers.add(modifier);
    }

    @Override
    public void removeBeeListener(IBeeListener modifier) {
        this.eventHandlers.remove(modifier);
    }

    @Override
    public void addTemperatureChange(float change, float boundaryDown, float boundaryUp) {
        this.tempChange = Math.min(boundaryUp - this.temperature, Math.max(boundaryDown - this.temperature, this.tempChange + change));
    }

    @Override
    public void addHumidityChange(float change, float boundaryDown, float boundaryUp) {
        this.humidChange = Math.min(boundaryUp - this.humidity, Math.max(boundaryDown - this.humidity, this.humidChange + change));
    }

    @Override
    public int getXCoord() {
        return this.l;
    }

    @Override
    public int getYCoord() {
        return this.m;
    }

    @Override
    public int getZCoord() {
        return this.n;
    }

    @Override
    public ur getQueen() {
        return this.a(0);
    }

    @Override
    public ur getDrone() {
        return this.a(1);
    }

    @Override
    public void setQueen(ur itemstack) {
        this.a(0, itemstack);
    }

    @Override
    public void setDrone(ur itemstack) {
        this.a(1, itemstack);
    }

    @Override
    public int getBiomeId() {
        return this.biomeId;
    }

    @Override
    public EnumTemperature getTemperature() {
        if (this.biomeId == yy.j.N && this.tempChange >= 0.0f) {
            return EnumTemperature.HELLISH;
        }
        return ClimateHelper.getTemperature(this.getExactTemperature());
    }

    @Override
    public EnumHumidity getHumidity() {
        return ClimateHelper.getHumidity(this.getExactHumidity());
    }

    @Override
    public float getTerritoryModifier(IBeeGenome genome) {
        float mod = 2.0f;
        for (IBeeModifier modifier : this.modifiers) {
            mod *= modifier.getTerritoryModifier(genome);
        }
        return mod;
    }

    @Override
    public float getProductionModifier(IBeeGenome genome) {
        float mod = 1.0f;
        for (IBeeModifier modifier : this.modifiers) {
            mod *= modifier.getProductionModifier(genome);
        }
        return mod;
    }

    @Override
    public float getMutationModifier(IBeeGenome genome, IBeeGenome mate) {
        float mod = 1.0f;
        for (IBeeModifier modifier : this.modifiers) {
            mod *= modifier.getMutationModifier(genome, mate);
        }
        return mod;
    }

    @Override
    public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate) {
        float mod = 1.0f;
        for (IBeeModifier modifier : this.modifiers) {
            mod *= modifier.getLifespanModifier(genome, mate);
        }
        return mod;
    }

    @Override
    public float getFloweringModifier(IBeeGenome genome) {
        float mod = 1.0f;
        for (IBeeModifier modifier : this.modifiers) {
            mod *= modifier.getFloweringModifier(genome);
        }
        return mod;
    }

    @Override
    public yc getWorld() {
        return this.k;
    }

    @Override
    public void setErrorState(int state) {
        this.setErrorState(EnumErrorCode.values()[state]);
    }

    @Override
    public int getErrorOrdinal() {
        return this.getErrorState().ordinal();
    }

    @Override
    public boolean canBreed() {
        return true;
    }

    @Override
    public boolean addProduct(ur product, boolean all) {
        if (this.inventory == null) {
            return false;
        }
        return this.inventory.tryAddStack(product, 2, this.inventory.k_() - 2, all);
    }

    @Override
    public void wearOutEquipment(int amount) {
        for (IBeeListener eventHandler : this.eventHandlers) {
            eventHandler.wearOutEquipment(amount);
        }
    }

    @Override
    public void onQueenChange(ur queenStack) {
        if (!Proxies.common.isSimulating(this.k)) {
            return;
        }
        Proxies.net.sendNetworkPacket(new PacketInventoryStack(3, this.l, this.m, this.n, 0, queenStack), this.l, this.m, this.n);
        for (IBeeListener eventHandler : this.eventHandlers) {
            eventHandler.onQueenChange(queenStack);
        }
    }

    @Override
    public void onQueenDeath(IBee queen) {
        for (IBeeListener eventHandler : this.eventHandlers) {
            eventHandler.onQueenDeath(queen);
        }
    }

    @Override
    public void onPostQueenDeath(IBee queen) {
        for (IBeeListener eventHandler : this.eventHandlers) {
            eventHandler.onPostQueenDeath(queen);
        }
    }

    @Override
    public boolean isSealed() {
        for (IBeeModifier modifier : this.modifiers) {
            if (!modifier.isSealed()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSelfLighted() {
        for (IBeeModifier modifier : this.modifiers) {
            if (!modifier.isSelfLighted()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSunlightSimulated() {
        for (IBeeModifier modifier : this.modifiers) {
            if (!modifier.isSunlightSimulated()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isHellish() {
        for (IBeeModifier modifier : this.modifiers) {
            if (!modifier.isHellish()) continue;
            return true;
        }
        return false;
    }

    private la getStructureInventory() {
        ITileStructure central;
        if (this.inventory != null) {
            if (this.isMaster() || !Proxies.common.isSimulating(this.k)) {
                return this.inventory;
            }
        } else if (this.hasMaster() && (central = this.getCentralTE()) != null) {
            return central.getInventory();
        }
        return null;
    }

    public int k_() {
        la inv = this.getStructureInventory();
        if (inv != null) {
            return inv.k_();
        }
        return 0;
    }

    public ur a(int slotIndex) {
        la inv = this.getStructureInventory();
        if (inv != null) {
            return inv.a(slotIndex);
        }
        return null;
    }

    public ur a(int slotIndex, int amount) {
        la inv = this.getStructureInventory();
        if (inv != null) {
            return inv.a(slotIndex, amount);
        }
        return null;
    }

    public ur a_(int slotIndex) {
        la inv = this.getStructureInventory();
        if (inv != null) {
            return inv.a_(slotIndex);
        }
        return null;
    }

    public void a(int slotIndex, ur itemstack) {
        la inv;
        if (this.inventory == null && !Proxies.common.isSimulating(this.k)) {
            this.createInventory();
        }
        if ((inv = this.getStructureInventory()) != null) {
            inv.a(slotIndex, itemstack);
        }
    }

    @Override
    public String b() {
        return "tile.alveary.0";
    }

    public int c() {
        la inv = this.getStructureInventory();
        if (inv != null) {
            return inv.c();
        }
        return 0;
    }

    public void l_() {
    }

    public void f() {
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        la inv = this.getStructureInventory();
        if (inv == null) {
            return 0;
        }
        if ((stack.c == ForestryItem.beePrincessGE.cj || stack.c == ForestryItem.beeQueenGE.cj) && inv.a(0) == null) {
            if (doAdd) {
                inv.a(0, stack.l());
                inv.a((int)0).a = 1;
            }
            return 1;
        }
        if (stack.c == ForestryItem.beeDroneGE.cj) {
            int added;
            ur droneStack = inv.a(1);
            if (droneStack == null) {
                if (doAdd) {
                    inv.a(1, stack.l());
                }
                return stack.a;
            }
            if (!droneStack.a(stack)) {
                return 0;
            }
            if (!ur.a((ur)droneStack, (ur)stack)) {
                return 0;
            }
            int space = droneStack.d() - droneStack.a;
            if (space <= 0) {
                return 0;
            }
            int n = added = space > stack.a ? stack.a : space;
            if (doAdd) {
                droneStack.a += added;
            }
            return added;
        }
        return 0;
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        la inv = this.getStructureInventory();
        if (inv == null) {
            return new ur[0];
        }
        ur product = null;
        for (int i = 2; i < inv.k_(); ++i) {
            if (inv.a(i) == null) continue;
            ur stack = inv.a(i);
            if (doRemove) {
                product = inv.a(i, 1);
                break;
            }
            product = stack.l();
            product.a = 1;
            break;
        }
        return new ur[]{product};
    }

    public int getStartInventorySide(ForgeDirection side) {
        switch (side) {
            case NORTH: 
            case SOUTH: {
                return 1;
            }
            case WEST: 
            case EAST: {
                return 0;
            }
        }
        return 2;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        switch (side) {
            case NORTH: 
            case SOUTH: 
            case WEST: 
            case EAST: {
                return 1;
            }
        }
        return 7;
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.displayHealth = j;
                break;
            }
            case 1: {
                this.displayHealthMax = j;
                break;
            }
            case 2: {
                this.temperature = (float)j / 100.0f;
                break;
            }
            case 3: {
                this.humidity = (float)j / 100.0f;
                break;
            }
            case 4: {
                this.tempChange = (float)j / 100.0f;
                break;
            }
            case 5: {
                this.humidChange = (float)j / 100.0f;
                break;
            }
            case 6: {
                this.biomeId = j;
            }
        }
    }

    public void sendGUINetworkData(ContainerAlveary container, rw iCrafting) {
        if (this.beekeepingLogic == null) {
            return;
        }
        iCrafting.a((rq)container, 0, this.beekeepingLogic.getBreedingTime());
        iCrafting.a((rq)container, 1, this.beekeepingLogic.getTotalBreedingTime());
        iCrafting.a((rq)container, 2, Math.round(this.temperature * 100.0f));
        iCrafting.a((rq)container, 3, Math.round(this.humidity * 100.0f));
        iCrafting.a((rq)container, 4, Math.round(this.tempChange * 100.0f));
        iCrafting.a((rq)container, 5, Math.round(this.humidChange * 100.0f));
        iCrafting.a((rq)container, 6, this.biomeId);
    }

    @Override
    public EnumErrorCode getErrorState() {
        ITileStructure tile;
        if (this.hasMaster() && (tile = this.getCentralTE()) != null) {
            return ((IErrorSource)((Object)tile)).getErrorState();
        }
        return this.errorState;
    }

    @Override
    public boolean isClimatized() {
        return true;
    }

    @Override
    public float getExactTemperature() {
        return this.temperature + this.tempChange;
    }

    @Override
    public float getExactHumidity() {
        return this.humidity + this.humidChange;
    }

    @Override
    public boolean hasHints() {
        return ((String[])Config.hints.get("alveary")).length > 0;
    }

    @Override
    public String[] getHints() {
        return (String[])Config.hints.get("alveary");
    }

    @Override
    public boolean isOwnable() {
        return true;
    }
}

