/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.AlleleEffectThrottled;
import forestry.apiculture.items.ItemArmorApiarist;
import forestry.plugins.PluginForestryApiculture;
import java.util.List;

public class AlleleEffectIgnition
extends AlleleEffectThrottled {
    int ignitionChance = 50;
    int fireDuration = 500;

    public AlleleEffectIgnition(String uid) {
        super(uid, "ignition", false, 20, true);
    }

    @Override
    public IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        yc world = housing.getWorld();
        if (this.isThrottled(storedData)) {
            return storedData;
        }
        aoe hurtBox = this.getBounding(genome, housing, 1.0f);
        List list = world.a(md.class, hurtBox);
        for (Object obj : list) {
            md entity = (md)obj;
            int chance = this.ignitionChance;
            int duration = this.fireDuration;
            if (entity instanceof qx) {
                int count = ItemArmorApiarist.wearsItems((qx)entity);
                if (count > 3) continue;
                if (count > 2) {
                    chance = 5;
                    duration = 50;
                } else if (count > 1) {
                    chance = 20;
                    duration = 200;
                } else if (count > 0) {
                    chance = 35;
                    duration = 350;
                }
            }
            if (world.t.nextInt(1000) >= chance) continue;
            entity.c(duration);
        }
        return storedData;
    }

    @Override
    public IEffectData doFX(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        int[] area = this.getModifiedArea(genome, housing);
        if (housing.getWorld().t.nextBoolean()) {
            PluginForestryApiculture.proxy.addBeeHiveFX("/gfx/forestry/particles/swarm_bee.png", housing.getWorld(), housing.getXCoord(), housing.getYCoord(), housing.getZCoord(), genome.getPrimaryAsBee().getPrimaryColor(), area[0], area[1], area[2]);
        } else {
            PluginForestryApiculture.proxy.addBeeHiveFX("/gfx/forestry/particles/ember.png", housing.getWorld(), housing.getXCoord(), housing.getYCoord(), housing.getZCoord(), 0xFFFFFF, area[0], area[1], area[2]);
        }
        return storedData;
    }
}

