/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.items;

import forestry.arboriculture.WoodType;
import forestry.arboriculture.gadgets.TileStairs;
import forestry.core.config.ForestryBlock;
import forestry.core.items.ItemForestryBlock;
import forestry.core.utils.StringUtil;

public class ItemStairs
extends ItemForestryBlock {
    public ItemStairs(int i, String name) {
        super(i, name);
        this.setTextureFile("/gfx/forestry/blocks/arboriculture.png");
    }

    public boolean placeBlockAt(ur stack, qx player, yc world, int x, int y2, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        WoodType type = WoodType.getFromCompound(stack.p());
        return this.placeStairs(world, player, type, x, y2, z);
    }

    private boolean placeStairs(yc world, qx player, WoodType type, int x, int y2, int z) {
        boolean placed = world.d(x, y2, z, ForestryBlock.stairs.cm, 0);
        if (!placed) {
            return false;
        }
        if (world.a(x, y2, z) != ForestryBlock.stairs.cm) {
            return false;
        }
        amq.p[world.a(x, y2, z)].a(world, x, y2, z, (md)player);
        any tile = world.q(x, y2, z);
        if (!(tile instanceof TileStairs)) {
            world.d(x, y2, z, 0, 0);
            return false;
        }
        ((TileStairs)tile).setType(type);
        return true;
    }

    private String getWoodNameIS(WoodType type) {
        return StringUtil.localize("wood." + type.ordinal());
    }

    @Override
    public String l(ur itemstack) {
        WoodType type = WoodType.getFromCompound(itemstack.p());
        return this.getWoodNameIS(type) + " " + StringUtil.localize("tile." + this.name);
    }
}

