/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import forestry.api.core.IOreDictionaryHandler;
import forestry.api.core.IPickupHandler;
import forestry.api.core.ISaveEventHandler;
import forestry.plugins.PluginManager;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.oredict.OreDictionary;

public class EventHandlerCore {
    @ForgeSubscribe
    public void handleItemPickup(EntityItemPickupEvent event) {
        if (event.isCanceled()) {
            return;
        }
        for (IPickupHandler handler : PluginManager.pickupHandlers) {
            if (handler.onItemPickup(event.entityPlayer, event.item)) continue;
            event.setResult(Event.Result.ALLOW);
            return;
        }
    }

    @ForgeSubscribe
    public void handleOreRegistration(OreDictionary.OreRegisterEvent event) {
        if (event.isCanceled()) {
            return;
        }
        for (IOreDictionaryHandler handler : PluginManager.dictionaryHandlers) {
            handler.onOreRegistration(event.Name, event.Ore);
        }
    }

    @ForgeSubscribe
    public void handleWorldLoad(WorldEvent.Load event) {
        for (ISaveEventHandler handler : PluginManager.saveEventHandlers) {
            handler.onWorldLoad(event.world);
        }
    }

    @ForgeSubscribe
    public void handleWorldSave(WorldEvent.Save event) {
        for (ISaveEventHandler handler : PluginManager.saveEventHandlers) {
            handler.onWorldSave(event.world);
        }
    }

    @ForgeSubscribe
    public void handleWorldUnload(WorldEvent.Unload event) {
        for (ISaveEventHandler handler : PluginManager.saveEventHandlers) {
            handler.onWorldUnload(event.world);
        }
    }
}

