/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IClassification;
import forestry.core.genetics.Allele;
import forestry.core.utils.Localization;
import forestry.core.utils.StringUtil;

public abstract class AlleleSpecies
extends Allele
implements IAlleleSpecies {
    private String name;
    private String binomial;
    private String description = null;
    private int bodyType = 0;
    private boolean hasEffect = false;
    private boolean isSecret = false;
    private boolean isCounted = true;
    private int primaryColor;
    private int secondaryColor;
    private jg achievement = null;
    private IClassification branch = null;
    private EnumTemperature climate = EnumTemperature.NORMAL;
    private EnumHumidity humidity = EnumHumidity.NORMAL;

    public AlleleSpecies(String uid, boolean isDominant, String name, IClassification branch, String binomial, int primaryColor, int secondaryColor) {
        super(uid, isDominant, true);
        this.branch = branch;
        this.name = name;
        this.binomial = binomial;
        this.primaryColor = primaryColor;
        this.secondaryColor = secondaryColor;
        if (Localization.instance.hasMapping("description." + uid)) {
            this.description = StringUtil.localize("description." + uid);
        }
        AlleleManager.alleleRegistry.registerAllele(this);
    }

    public AlleleSpecies setBodyType(int bodyType) {
        this.bodyType = bodyType;
        return this;
    }

    @Override
    public String getName() {
        return StringUtil.localize(this.name);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int getBodyType() {
        return this.bodyType;
    }

    @Override
    public int getPrimaryColor() {
        return this.primaryColor;
    }

    @Override
    public int getSecondaryColor() {
        return this.secondaryColor;
    }

    @Override
    public EnumTemperature getTemperature() {
        return this.climate;
    }

    @Override
    public EnumHumidity getHumidity() {
        return this.humidity;
    }

    @Override
    public boolean hasEffect() {
        return this.hasEffect;
    }

    @Override
    public boolean isSecret() {
        return this.isSecret;
    }

    @Override
    public boolean isCounted() {
        return this.isCounted;
    }

    @Override
    public String getBinomial() {
        return this.binomial;
    }

    @Override
    public String getAuthority() {
        return "Sengir";
    }

    @Override
    public jg getAchievement() {
        return this.achievement;
    }

    @Override
    public IClassification getBranch() {
        return this.branch;
    }

    public AlleleSpecies setTemperature(EnumTemperature temperature) {
        this.climate = temperature;
        return this;
    }

    public AlleleSpecies setHumidity(EnumHumidity humidity) {
        this.humidity = humidity;
        return this;
    }

    public AlleleSpecies setHasEffect() {
        this.hasEffect = true;
        return this;
    }

    public AlleleSpecies setIsSecret() {
        this.isSecret = true;
        return this;
    }

    public AlleleSpecies setIsNotCounted() {
        this.isCounted = false;
        return this;
    }

    public AlleleSpecies setAchievement(jg achievement) {
        this.achievement = achievement;
        return this;
    }
}

