/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.core.config.Config;
import forestry.core.gadgets.TileForestry;
import forestry.core.gui.ClimateLedger;
import forestry.core.gui.ContainerForestry;
import forestry.core.gui.ErrorLedger;
import forestry.core.gui.GfxSlotManager;
import forestry.core.gui.HintLedger;
import forestry.core.gui.ITextureSlot;
import forestry.core.gui.LedgerManager;
import forestry.core.gui.OwnerLedger;
import forestry.core.gui.PowerLedger;
import forestry.core.interfaces.IClimatised;
import forestry.core.interfaces.IEnergyConsumer;
import forestry.core.interfaces.IErrorSource;
import forestry.core.interfaces.IHintSource;
import forestry.core.interfaces.IOwnable;
import forestry.core.proxy.Proxies;
import forestry.core.utils.FontColour;
import java.util.List;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public abstract class GuiForestry
extends aul {
    protected GfxSlotManager slotManager;
    protected LedgerManager ledgerManager = new LedgerManager(this);
    protected TileForestry tile;
    protected String textureFile;
    protected static bce itemRenderer = new bce();
    protected int xSize = 176;
    protected int ySize = 166;
    public ContainerForestry inventorySlots;
    protected int guiLeft;
    protected int guiTop;
    protected FontColour fontColor;
    protected int playerInventorySize;
    protected int pageCurrent = 0;
    protected int pageSize = 25;
    protected int pageMax = 1;
    private int column0;
    private int column1;
    private int column2;
    private int line;
    protected final float factor = 0.75f;

    public GuiForestry(ContainerForestry container) {
        this("", container, null, 1, 0);
    }

    public GuiForestry(String texture, ContainerForestry container) {
        this(texture, container, null, 1, 0);
    }

    public GuiForestry(String texture, ContainerForestry container, Object tile) {
        this(texture, container, tile, 1, 0);
    }

    public GuiForestry(String texture, ContainerForestry container, la tile) {
        this(texture, container, tile, 1, tile.k_());
    }

    public GuiForestry(String texture, ContainerForestry container, Object inventory, int pageMax, int pageSize) {
        this.slotManager = new GfxSlotManager(this);
        this.ledgerManager = new LedgerManager(this);
        this.textureFile = texture;
        this.inventorySlots = container;
        this.pageMax = pageMax;
        this.pageSize = pageSize;
        if (inventory instanceof TileForestry) {
            this.tile = (TileForestry)inventory;
        }
        this.fontColor = new FontColour(Proxies.common.getSelectedTexturePack(Proxies.common.getClientInstance()));
        this.initLedgers(inventory);
    }

    protected void initLedgers(Object inventory) {
        if (inventory instanceof IErrorSource && ((IErrorSource)inventory).throwsErrors()) {
            this.ledgerManager.add(new ErrorLedger(this.ledgerManager, (IErrorSource)inventory));
        }
        if (inventory instanceof IClimatised && ((IClimatised)inventory).isClimatized()) {
            this.ledgerManager.add(new ClimateLedger(this.ledgerManager, (IClimatised)inventory));
        }
        if (!Config.disableEnergyStat && inventory instanceof IEnergyConsumer && ((IEnergyConsumer)inventory).consumesEnergy()) {
            this.ledgerManager.add(new PowerLedger(this.ledgerManager, (IEnergyConsumer)inventory));
        }
        if (!Config.disableHints && inventory instanceof IHintSource && ((IHintSource)inventory).hasHints()) {
            this.ledgerManager.add(new HintLedger(this.ledgerManager, (IHintSource)inventory));
        }
        if (inventory instanceof IOwnable && ((IOwnable)inventory).isOwnable()) {
            this.ledgerManager.add(new OwnerLedger(this.ledgerManager, (IOwnable)inventory));
        }
    }

    protected final void startPage() {
        this.line = 12;
        GL11.glPushMatrix();
        GL11.glScalef((float)0.75f, (float)0.75f, (float)0.75f);
    }

    protected final void startPage(int column0, int column1, int column2) {
        this.column0 = column0;
        this.column1 = column1;
        this.column2 = column2;
        this.startPage();
    }

    protected final int adjustToFactor(int fixed) {
        return (int)((float)fixed * 1.3333334f);
    }

    protected final int getLineY() {
        return this.line;
    }

    protected final void newLine() {
        this.line = (int)((float)this.line + 9.0f);
    }

    protected final void newLine(int lineHeight) {
        this.line = (int)((float)this.line + (float)lineHeight * 0.75f);
    }

    protected final void endPage() {
        GL11.glPopMatrix();
    }

    protected final void drawRow(String text0, String text1, String text2, int colour0, int colour1, int colour2) {
        this.drawLine(text0, this.column0, colour0);
        this.drawLine(text1, this.column1, colour1);
        this.drawLine(text2, this.column2, colour2);
        this.newLine();
    }

    protected final void drawLine(String text, int x2) {
        this.drawLine(text, x2, this.fontColor.get("gui.screen"));
    }

    protected final void drawSplitLine(String text, int x2, int maxWidth) {
        this.drawSplitLine(text, x2, maxWidth, this.fontColor.get("gui.screen"));
    }

    protected final void drawCenteredLine(String text, int x2, int width) {
        this.drawCenteredLine(text, x2, width, this.fontColor.get("gui.screen"));
    }

    protected final void drawCenteredLine(String text, int x2, int width, int color) {
        this.l.b(text, (int)((float)(this.guiLeft + x2) * 1.3333334f) + (this.adjustToFactor(width) - this.l.a(text)) / 2, (int)((float)(this.guiTop + this.line) * 1.3333334f), color);
    }

    protected final void drawLine(String text, int x2, int color) {
        this.l.b(text, (int)((float)(this.guiLeft + x2) * 1.3333334f), (int)((float)(this.guiTop + this.line) * 1.3333334f), color);
    }

    protected final void drawSplitLine(String text, int x2, int maxWidth, int color) {
        this.l.a(text, (int)((float)(this.guiLeft + x2) * 1.3333334f), (int)((float)(this.guiTop + this.line) * 1.3333334f), (int)((float)maxWidth * 1.3333334f), color);
    }

    public void A_() {
        super.A_();
        this.f.g.bL = this.inventorySlots;
        this.guiLeft = (this.g - this.xSize) / 2;
        this.guiTop = (this.h - this.ySize) / 2;
    }

    protected void flipPage(int page) {
        this.pageCurrent = page;
    }

    protected int getCenteredOffset(String string) {
        return this.getCenteredOffset(string, this.xSize);
    }

    protected int getCenteredOffset(String string, int xWidth) {
        return (xWidth - this.l.a(string)) / 2;
    }

    protected void drawGuiContainerForegroundLayer() {
    }

    protected abstract void drawGuiContainerBackgroundLayer(float var1, int var2, int var3);

    protected void drawTooltip(int mouseX, int mouseY, float zLevel, List information, vb rarity) {
        if (information.size() > 0) {
            this.j = 0.0f;
            GuiForestry.itemRenderer.f = 0.0f;
            int tooltipWidth = 0;
            for (int i = 0; i < information.size(); ++i) {
                int textWidth = this.l.a((String)information.get(i));
                if (textWidth <= tooltipWidth) continue;
                tooltipWidth = textWidth;
            }
            int xPos = mouseX - this.guiLeft + 12;
            int yPos = mouseY - this.guiTop - 12;
            int var14 = 8;
            if (information.size() > 1) {
                var14 += 2 + (information.size() - 1) * 10;
            }
            this.j = zLevel;
            GuiForestry.itemRenderer.f = zLevel;
            int var15 = -267386864;
            this.a(xPos - 3, yPos - 4, xPos + tooltipWidth + 3, yPos - 3, var15, var15);
            this.a(xPos - 3, yPos + var14 + 3, xPos + tooltipWidth + 3, yPos + var14 + 4, var15, var15);
            this.a(xPos - 3, yPos - 3, xPos + tooltipWidth + 3, yPos + var14 + 3, var15, var15);
            this.a(xPos - 4, yPos - 3, xPos - 3, yPos + var14 + 3, var15, var15);
            this.a(xPos + tooltipWidth + 3, yPos - 3, xPos + tooltipWidth + 4, yPos + var14 + 3, var15, var15);
            int var16 = 0x505000FF;
            int var17 = (var16 & 0xFEFEFE) >> 1 | var16 & 0xFF000000;
            this.a(xPos - 3, yPos - 3 + 1, xPos - 3 + 1, yPos + var14 + 3 - 1, var16, var17);
            this.a(xPos + tooltipWidth + 2, yPos - 3 + 1, xPos + tooltipWidth + 3, yPos + var14 + 3 - 1, var16, var17);
            this.a(xPos - 3, yPos - 3, xPos + tooltipWidth + 3, yPos - 3 + 1, var16, var16);
            this.a(xPos - 3, yPos + var14 + 2, xPos + tooltipWidth + 3, yPos + var14 + 3, var17, var17);
            for (int i = 0; i < information.size(); ++i) {
                String line = (String)information.get(i);
                line = i == 0 ? "\u00a7" + Integer.toHexString(rarity.e) + line : "\u00a77" + line;
                this.l.a(line, xPos, yPos, -1);
                if (i == 0) {
                    yPos += 2;
                }
                yPos += 10;
            }
            this.j = 0.0f;
            GuiForestry.itemRenderer.f = 0.0f;
        }
    }

    protected void drawBackground() {
        this.guiLeft = (this.g - this.xSize) / 2;
        this.guiTop = (this.h - this.ySize) / 2;
        this.bindTexture();
        this.b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
    }

    protected void bindTexture() {
        this.bindTexture(this.textureFile);
    }

    protected void bindTexture(String texturePath) {
        int texture = this.f.o.b(texturePath);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.f.o.b(texture);
    }

    public void a(int mouseX, int mouseY, float par3) {
        sr mousedSlot;
        int i;
        this.e();
        this.drawGuiContainerBackgroundLayer(par3, mouseX, mouseY);
        arw.c();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        sr mousedOverSlot = null;
        int var7 = 240;
        int var8 = 240;
        bfe.a((int)bfe.b, (float)((float)var7 / 1.0f), (float)((float)var8 / 1.0f));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.pageSize > 0) {
            for (i = this.pageCurrent * this.pageSize; i < (this.pageCurrent + 1) * this.pageSize; ++i) {
                mousedSlot = this.drawSlot(i, mouseX, mouseY);
                if (mousedSlot == null) continue;
                mousedOverSlot = mousedSlot;
            }
        }
        for (i = this.pageMax * this.pageSize; i < this.inventorySlots.c.size(); ++i) {
            mousedSlot = this.drawSlot(i, mouseX, mouseY);
            if (mousedSlot == null) continue;
            mousedOverSlot = mousedSlot;
        }
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        this.ledgerManager.drawLedgers();
        this.slotManager.drawSlots();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        this.drawGuiContainerForegroundLayer();
        qw playerInventory = this.f.g.bJ;
        if (playerInventory.n() != null) {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
            this.j = 200.0f;
            GuiForestry.itemRenderer.f = 200.0f;
            itemRenderer.b(this.l, this.f.o, playerInventory.n(), mouseX - this.guiLeft - 8, mouseY - this.guiTop - 8);
            itemRenderer.c(this.l, this.f.o, playerInventory.n(), mouseX - this.guiLeft - 8, mouseY - this.guiTop - 8);
            this.j = 0.0f;
            GuiForestry.itemRenderer.f = 0.0f;
        }
        GL11.glDisable((int)32826);
        arw.a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        if (playerInventory.n() == null && mousedOverSlot != null && mousedOverSlot.d()) {
            ur slotStack = mousedOverSlot.c();
            this.drawTooltip(mouseX, mouseY, 300.0f, slotStack.a((qx)Proxies.common.getClientInstance().g, false), slotStack.u());
        }
        this.ledgerManager.drawTooltips(mouseX, mouseY);
        this.slotManager.drawTooltips(mouseX, mouseY);
        GL11.glPopMatrix();
        super.a(mouseX, mouseY, par3);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    protected sr drawSlot(int slotIndex, int mouseX, int mouseY) {
        sr mousedOverSlot = null;
        sr slot = (sr)this.inventorySlots.c.get(slotIndex);
        this.drawSlotInventory(slot);
        if (this.getIsMouseOverSlot(slot, mouseX, mouseY)) {
            mousedOverSlot = slot;
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int var9 = slot.h;
            int var10 = slot.i;
            this.a(var9, var10, var9 + 16, var10 + 16, -2130706433, -2130706433);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
        }
        return mousedOverSlot;
    }

    protected void drawSlotInventory(sr slot) {
        int backgroundIndex;
        int xPos = slot.h;
        int yPos = slot.i;
        ur slotStack = slot.c();
        boolean backgroundDrawn = false;
        this.j = 100.0f;
        GuiForestry.itemRenderer.f = 100.0f;
        if (slotStack == null && (backgroundIndex = slot.b()) >= 0) {
            GL11.glDisable((int)2896);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (slot instanceof ITextureSlot) {
                this.f.o.b(this.f.o.b(((ITextureSlot)slot).getTextureFile()));
            } else {
                this.f.o.b(this.f.o.b("/gui/items.png"));
            }
            this.b(xPos, yPos, backgroundIndex % 16 * 16, backgroundIndex / 16 * 16, 16, 16);
            GL11.glEnable((int)2896);
            backgroundDrawn = true;
        }
        if (!backgroundDrawn && slotStack != null) {
            itemRenderer.b(this.l, this.f.o, slotStack, xPos, yPos);
            itemRenderer.c(this.l, this.f.o, slotStack, xPos, yPos);
        }
        GuiForestry.itemRenderer.f = 0.0f;
        this.j = 0.0f;
    }

    public void a(int par1, int par2, int par3, int par4, int par5, int par6) {
        super.a(par1, par2, par3, par4, par5, par6);
    }

    protected sr getSlotAtPosition(int i, int j) {
        sr slot;
        int k;
        for (k = this.pageCurrent * this.pageSize; k < (this.pageCurrent + 1) * this.pageSize; ++k) {
            slot = (sr)this.inventorySlots.c.get(k);
            if (!this.getIsMouseOverSlot(slot, i, j)) continue;
            return slot;
        }
        for (k = this.pageMax * this.pageSize; k < this.inventorySlots.c.size(); ++k) {
            slot = (sr)this.inventorySlots.c.get(k);
            if (!this.getIsMouseOverSlot(slot, i, j)) continue;
            return slot;
        }
        return null;
    }

    protected boolean getIsMouseOverSlot(sr slot, int i, int j) {
        int k = this.guiLeft;
        int l = this.guiTop;
        return (i -= k) >= slot.h - 1 && i < slot.h + 16 + 1 && (j -= l) >= slot.i - 1 && j < slot.i + 16 + 1;
    }

    protected void a(int xPos, int yPos, int mouseButton) {
        boolean var4;
        super.a(xPos, yPos, mouseButton);
        boolean bl = var4 = mouseButton == this.f.y.Q.d + 100;
        if (mouseButton == 0 || mouseButton == 1 || var4) {
            sr slot = this.getSlotAtPosition(xPos, yPos);
            int xStart = this.guiLeft;
            int yStart = this.guiTop;
            boolean var7 = xPos < xStart || yPos < yStart || xPos >= xStart + this.xSize || yPos >= yStart + this.ySize;
            int slotNum = -1;
            if (slot != null) {
                slotNum = slot.g;
            }
            if (var7) {
                slotNum = -999;
            }
            if (slotNum != -1) {
                if (var4) {
                    this.handleMouseClick(slot, slotNum, mouseButton, 3);
                } else {
                    boolean var9 = slotNum != -999 && (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54));
                    this.handleMouseClick(slot, slotNum, mouseButton, var9 ? 1 : 0);
                }
            }
        }
        this.ledgerManager.handleMouseClicked(xPos, yPos, mouseButton);
        this.slotManager.handleMouseClicked(xPos, yPos, mouseButton);
    }

    protected void handleMouseClick(sr slot, int slotIndex, int mouseButton, int par4) {
        if (slot != null) {
            slotIndex = slot.g;
        }
        this.f.b.a(this.inventorySlots.d, slotIndex, mouseButton, par4, (qx)this.f.g);
    }

    protected void a(char par1, int par2) {
        if (par2 == 1 || par2 == this.f.y.J.d) {
            this.f.g.i();
        }
    }

    public void b() {
        if (this.f.g != null) {
            this.inventorySlots.b((qx)this.f.g);
        }
    }

    public boolean f() {
        return false;
    }

    public void c() {
        super.c();
        if (!this.f.g.S() || this.f.g.L) {
            this.f.g.i();
        }
    }
}

