/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.core.config.SessionVars;
import forestry.core.gui.LedgerManager;
import org.lwjgl.opengl.GL11;

public abstract class Ledger {
    protected LedgerManager manager;
    private boolean open;
    protected int overlayColor = 0xFFFFFF;
    public int currentShiftX = 0;
    public int currentShiftY = 0;
    protected int limitWidth = 128;
    protected int maxWidth = 124;
    protected int minWidth;
    protected int currentWidth = this.minWidth = 24;
    protected int maxHeight = 24;
    protected int minHeight;
    protected int currentHeight = this.minHeight = 24;

    public Ledger(LedgerManager manager) {
        this.manager = manager;
    }

    public void update() {
        if (this.open && this.currentWidth < this.maxWidth) {
            this.currentWidth += 4;
        } else if (!this.open && this.currentWidth > this.minWidth) {
            this.currentWidth -= 4;
        }
        if (this.open && this.currentHeight < this.maxHeight) {
            this.currentHeight += 4;
        } else if (!this.open && this.currentHeight > this.minHeight) {
            this.currentHeight -= 4;
        }
    }

    public int getHeight() {
        return this.currentHeight;
    }

    public abstract void draw(int var1, int var2);

    public abstract String getTooltip();

    public boolean handleMouseClicked(int x2, int y2, int mouseButton) {
        return false;
    }

    public boolean intersectsWith(int mouseX, int mouseY, int shiftX, int shiftY) {
        return mouseX >= shiftX && mouseX <= shiftX + this.currentWidth && mouseY >= shiftY && mouseY <= shiftY + this.getHeight();
    }

    public void setFullyOpen() {
        this.open = true;
        this.currentWidth = this.maxWidth;
        this.currentHeight = this.maxHeight;
    }

    public void toggleOpen() {
        if (this.open) {
            this.open = false;
            SessionVars.setOpenedLedger(null);
        } else {
            this.open = true;
            SessionVars.setOpenedLedger(this.getClass());
        }
    }

    public boolean isVisible() {
        return true;
    }

    public boolean isOpen() {
        return this.open;
    }

    protected boolean isFullyOpened() {
        return this.currentWidth >= this.maxWidth;
    }

    protected void drawBackground(int x2, int y2) {
        int texture = this.manager.minecraft.o.b("/gfx/forestry/gui/ledger.png");
        float colorR = (float)(this.overlayColor >> 16 & 0xFF) / 255.0f;
        float colorG = (float)(this.overlayColor >> 8 & 0xFF) / 255.0f;
        float colorB = (float)(this.overlayColor & 0xFF) / 255.0f;
        GL11.glColor4f((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
        this.manager.minecraft.o.b(texture);
        this.manager.gui.b(x2, y2, 0, 256 - this.currentHeight, 4, this.currentHeight);
        this.manager.gui.b(x2 + 4, y2, 256 - this.currentWidth + 4, 0, this.currentWidth - 4, 4);
        this.manager.gui.b(x2, y2, 0, 0, 4, 4);
        this.manager.gui.b(x2 + 4, y2 + 4, 256 - this.currentWidth + 4, 256 - this.currentHeight + 4, this.currentWidth - 4, this.currentHeight - 4);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void drawIcon(String texture, int iconIndex, int x2, int y2) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int tex = this.manager.minecraft.o.b(texture);
        this.manager.minecraft.o.b(tex);
        int textureRow = iconIndex >> 4;
        int textureColumn = iconIndex - 16 * textureRow;
        this.manager.gui.b(x2, y2, 16 * textureColumn, 16 * textureRow, 16, 16);
    }
}

