/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.core.gui.Ledger;
import forestry.core.gui.LedgerManager;
import forestry.core.interfaces.IEnergyConsumer;
import forestry.core.utils.StringUtil;

public class PowerLedger
extends Ledger {
    IEnergyConsumer tile;

    public PowerLedger(LedgerManager manager, IEnergyConsumer tile) {
        super(manager);
        this.tile = tile;
        this.maxHeight = 94;
        this.overlayColor = manager.gui.fontColor.get("ledger.power.background");
    }

    @Override
    public void draw(int x2, int y2) {
        this.drawBackground(x2, y2);
        this.drawIcon("/gfx/forestry/gui/misc.png", 0, x2 + 3, y2 + 4);
        if (!this.isFullyOpened()) {
            return;
        }
        this.manager.minecraft.p.a(StringUtil.localize("gui.energy"), x2 + 22, y2 + 8, this.manager.gui.fontColor.get("ledger.power.header"));
        this.manager.minecraft.p.a(StringUtil.localize("gui.stored") + ":", x2 + 22, y2 + 20, this.manager.gui.fontColor.get("ledger.power.subheader"));
        this.manager.minecraft.p.b(this.tile.getEnergyStored() + " MJ", x2 + 22, y2 + 32, this.manager.gui.fontColor.get("ledger.power.text"));
        this.manager.minecraft.p.a(StringUtil.localize("gui.maxenergy") + ":", x2 + 22, y2 + 44, this.manager.gui.fontColor.get("ledger.power.subheader"));
        this.manager.minecraft.p.b(this.tile.getMaxEnergyStored() + " MJ", x2 + 22, y2 + 56, this.manager.gui.fontColor.get("ledger.power.text"));
        this.manager.minecraft.p.a(StringUtil.localize("gui.maxenergyreceive") + ":", x2 + 22, y2 + 68, this.manager.gui.fontColor.get("ledger.power.subheader"));
        this.manager.minecraft.p.b(this.tile.getMaxEnergyReceived() + " MJ", x2 + 22, y2 + 80, this.manager.gui.fontColor.get("ledger.power.text"));
    }

    @Override
    public String getTooltip() {
        return this.tile.getEnergyStored() + " MJ";
    }
}

