/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import forestry.core.utils.Utils;

public class PacketPayload {
    public int[] intPayload = new int[0];
    public short[] shortPayload = new short[0];
    public float[] floatPayload = new float[0];
    public String[] stringPayload = new String[0];

    public PacketPayload() {
    }

    public PacketPayload(int intSize, int floatSize, int stringSize) {
        this.intPayload = new int[intSize];
        this.floatPayload = new float[floatSize];
        this.stringPayload = new String[stringSize];
    }

    public PacketPayload(int intSize, int shortSize) {
        this.intPayload = new int[intSize];
        this.shortPayload = new short[shortSize];
    }

    public void append(PacketPayload other) {
        if (other == null) {
            return;
        }
        if (other.intPayload.length > 0) {
            this.intPayload = Utils.concat(this.intPayload, other.intPayload);
        }
        if (other.shortPayload.length > 0) {
            this.shortPayload = Utils.concat(this.shortPayload, other.shortPayload);
        }
        if (other.floatPayload.length > 0) {
            this.floatPayload = Utils.concat(this.floatPayload, other.floatPayload);
        }
        if (other.stringPayload.length > 0) {
            this.stringPayload = (String[])Utils.concat(this.stringPayload, other.stringPayload);
        }
    }

    public void append(int[] other) {
        if (other == null || other.length < 0) {
            return;
        }
        this.intPayload = Utils.concat(this.intPayload, other);
    }

    public boolean isEmpty() {
        return this.intPayload.length == 0 && this.shortPayload.length == 0 && this.floatPayload.length == 0 && this.stringPayload.length == 0;
    }
}

