/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.triggers;

import buildcraft.api.gates.ITriggerParameter;
import forestry.core.gadgets.TileEngine;
import forestry.core.gadgets.TileMachine;
import forestry.core.triggers.Trigger;
import forestry.core.utils.StringUtil;

public class TriggerLowFuel
extends Trigger {
    private float threshold = 0.25f;

    public TriggerLowFuel(int id, float threshold) {
        super(id, 0);
        this.threshold = threshold;
    }

    @Override
    public String getDescription() {
        return StringUtil.localize("trigger.fuel") + " < " + this.threshold * 100.0f + "%";
    }

    @Override
    public boolean isTriggerActive(any tile, ITriggerParameter parameter) {
        if (tile instanceof TileMachine) {
            TileMachine machine = (TileMachine)tile;
            return !machine.machine.hasFuelMin(this.threshold);
        }
        if (tile instanceof TileEngine) {
            TileEngine engine = (TileEngine)tile;
            if (engine.engine != null) {
                return !engine.engine.hasFuelMin(this.threshold);
            }
            return false;
        }
        return false;
    }
}

