/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.core.interfaces.IDescriptiveRecipe;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraftforge.oredict.OreDictionary;

public class ShapedRecipeCustom
implements IDescriptiveRecipe {
    private int width;
    private int height;
    private Object[] ingredients;
    private ur product;
    private boolean preserveNBT = false;

    public ShapedRecipeCustom(int width, int height, Object[] ingredients, ur product) {
        this.width = width;
        this.height = height;
        this.ingredients = ingredients;
        this.product = product;
    }

    public ShapedRecipeCustom setPreserveNBT() {
        this.preserveNBT = true;
        return this;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public ur b() {
        return this.product;
    }

    @Override
    public Object[] getIngredients() {
        return this.ingredients;
    }

    public boolean a(ry inventorycrafting, yc world) {
        ur[][] resources = new ur[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                resources[i][j] = inventorycrafting.b(i, j);
            }
        }
        return this.matches(resources);
    }

    public boolean matches(ur[][] resources) {
        for (int i = 0; i <= 3 - this.width; ++i) {
            for (int j = 0; j <= 3 - this.height; ++j) {
                if (this.checkMatch(resources, i, j, true)) {
                    return true;
                }
                if (!this.checkMatch(resources, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(ur[][] resources, int xInGrid, int yInGrid, boolean flag) {
        for (int k = 0; k < 3; ++k) {
            for (int l = 0; l < 3; ++l) {
                int widthIt = k - xInGrid;
                int heightIt = l - yInGrid;
                Object compare = null;
                if (widthIt >= 0 && heightIt >= 0 && widthIt < this.width && heightIt < this.height) {
                    compare = flag ? this.ingredients[this.width - widthIt - 1 + heightIt * this.width] : this.ingredients[widthIt + heightIt * this.width];
                }
                ur resource = resources[k][l];
                if (compare instanceof ur) {
                    if (this.checkItemMatch((ur)compare, resource)) continue;
                    return false;
                }
                if (compare instanceof ArrayList) {
                    boolean matched = false;
                    for (ur item : (ArrayList)compare) {
                        matched = matched || this.checkItemMatch(item, resource);
                    }
                    if (matched) continue;
                    return false;
                }
                if (compare != null || resource == null) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkItemMatch(ur compare, ur resource) {
        if (resource == null && compare == null) {
            return true;
        }
        if (resource == null && compare != null || resource != null && compare == null) {
            return false;
        }
        if (compare.c != resource.c) {
            return false;
        }
        return compare.j() == -1 || compare.j() == resource.j();
    }

    public ur a(ry inventorycrafting) {
        if (this.preserveNBT) {
            for (int i = 0; i < inventorycrafting.k_(); ++i) {
                if (inventorycrafting.a(i) == null || !inventorycrafting.a(i).o()) continue;
                ur crafted = this.product.l();
                crafted.d((bq)inventorycrafting.a(i).p().b());
                return crafted;
            }
        }
        return this.product.l();
    }

    public int a() {
        return this.width * this.height;
    }

    public boolean isIngredient(ur resource) {
        for (Object ingredient : this.ingredients) {
            if (ingredient instanceof ur) {
                if (!this.checkItemMatch((ur)ingredient, resource)) continue;
                return true;
            }
            if (!(ingredient instanceof ArrayList)) continue;
            for (ur item : (ArrayList)ingredient) {
                if (!this.checkItemMatch(item, resource)) continue;
                return true;
            }
        }
        return false;
    }

    public static ShapedRecipeCustom createShapedRecipe(Object[] materials, ur product) {
        String s2 = "";
        int i = 0;
        int j = 0;
        int k = 0;
        if (materials[i] instanceof String[]) {
            String[] as = (String[])materials[i++];
            for (int l = 0; l < as.length; ++l) {
                String pattern = as[l];
                ++k;
                j = pattern.length();
                s2 = s2 + pattern;
            }
        } else {
            while (materials[i] instanceof String) {
                String pattern = (String)materials[i++];
                ++k;
                j = pattern.length();
                s2 = s2 + pattern;
            }
        }
        HashMap<Character, Object> hashmap = new HashMap<Character, Object>();
        while (i < materials.length) {
            Character character = (Character)materials[i];
            if (materials[i + 1] instanceof up) {
                hashmap.put(character, new ur((up)materials[i + 1]));
            } else if (materials[i + 1] instanceof amq) {
                hashmap.put(character, new ur((amq)materials[i + 1], 1, -1));
            } else if (materials[i + 1] instanceof ur) {
                hashmap.put(character, materials[i + 1]);
            } else if (materials[i + 1] instanceof String) {
                hashmap.put(character, OreDictionary.getOres((String)((String)materials[i + 1])));
            }
            i += 2;
        }
        Object[] ingredients = new Object[j * k];
        for (int l = 0; l < j * k; ++l) {
            char c = s2.charAt(l);
            ingredients[l] = hashmap.containsKey(Character.valueOf(c)) ? hashmap.get(Character.valueOf(c)) : null;
        }
        return new ShapedRecipeCustom(j, k, ingredients, product);
    }
}

