/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

public class Vect {
    public int x;
    public int y;
    public int z;

    public Vect(int[] dim) {
        if (dim.length != 3) {
            throw new RuntimeException("Cannot instantiate a vector with less or more than 3 points.");
        }
        this.x = dim[0];
        this.y = dim[1];
        this.z = dim[2];
    }

    public Vect(int x2, int y2, int z2) {
        this.x = x2;
        this.y = y2;
        this.z = z2;
    }

    public Vect add(Vect other) {
        Vect result = new Vect(this.x, this.y, this.z);
        result.x += other.x;
        result.y += other.y;
        result.z += other.z;
        return result;
    }

    public Vect multiply(float factor) {
        Vect result = new Vect(this.x, this.y, this.z);
        result.x = (int)((float)result.x * factor);
        result.y = (int)((float)result.y * factor);
        result.z = (int)((float)result.z * factor);
        return result;
    }

    public String toString() {
        return String.format("%sx%sx%s;", this.x, this.y, this.z);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vect other = (Vect)obj;
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.z == other.z;
    }
}

