/*
 * Decompiled with CFR 0.152.
 */
package forestry.cultivation.gadgets;

import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.Mill;
import forestry.core.gadgets.TileMill;
import forestry.core.proxy.Proxies;
import forestry.core.utils.Vect;
import forestry.plugins.PluginIC2;

public class MillTreetap
extends Mill {
    private Vect area = new Vect(21, 13, 21);
    private Vect posOffset = new Vect(-10, -2, -10);
    private Vect posCurrent = new Vect(0, 0, 0);
    private boolean isFinished = false;

    public MillTreetap(TileMill tile) {
        super(tile);
        this.speed = 0.025f;
    }

    @Override
    public String getName() {
        return "Treetaper";
    }

    @Override
    public void openGui(qx player, la tile) {
    }

    @Override
    protected void activate() {
        if (Proxies.common.isSimulating(this.tile.k)) {
            while (!this.isFinished) {
                int meta;
                this.advanceIterator();
                Vect posBlock = this.posCurrent.add(this.tile.Coords());
                posBlock = posBlock.add(this.posOffset);
                int blockid = this.tile.k.a(posBlock.x, posBlock.y, posBlock.z);
                if (blockid != PluginIC2.rubberwood.c || (meta = this.tile.k.h(posBlock.x, posBlock.y, posBlock.z)) <= 0) continue;
                this.tile.k.c(posBlock.x, posBlock.y, posBlock.z, 0);
                int amount = this.tile.k.t.nextInt(3) + 1;
                for (int i = 0; i < amount; ++i) {
                    px entity = new px(this.tile.k, (double)(posBlock.x + 1), (double)posBlock.y, (double)posBlock.z, PluginIC2.resin.l());
                    this.tile.k.d((lq)entity);
                }
            }
            if (this.isFinished) {
                this.resetIterator();
            }
            this.charge = 0;
            this.tileMill.sendNetworkUpdate();
        }
    }

    @Override
    public boolean doWork() {
        if (!PluginIC2.instance.isAvailable()) {
            return false;
        }
        if (!Proxies.common.isSimulating(this.tile.k)) {
            return false;
        }
        if (this.charge != 0) {
            return false;
        }
        this.charge = 1;
        return true;
    }

    @Override
    public boolean isWorking() {
        return PluginIC2.instance.isAvailable();
    }

    private void advanceIterator() {
        if (this.posCurrent.z < this.area.z - 1) {
            ++this.posCurrent.z;
        } else {
            this.posCurrent.z = 0;
            if (this.posCurrent.x < this.area.x - 1) {
                ++this.posCurrent.x;
            } else {
                this.posCurrent.x = 0;
                if (this.posCurrent.y < this.area.y - 1) {
                    ++this.posCurrent.y;
                } else {
                    this.isFinished = true;
                }
            }
        }
    }

    private void resetIterator() {
        this.isFinished = false;
        this.posCurrent = new Vect(0, 0, 0);
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(any tile) {
            return new MillTreetap((TileMill)tile);
        }
    }
}

