/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import forestry.api.core.ForestryAPI;
import forestry.api.recipes.IStillManager;
import forestry.api.recipes.RecipeManagers;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.TileMachine;
import forestry.core.network.EntityNetData;
import forestry.core.network.GuiId;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.StackUtils;
import forestry.core.utils.StringUtil;
import forestry.core.utils.TankSlot;
import forestry.core.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidStack;

public class MachineStill
extends Machine {
    public static final short SLOT_OUTPUT = 0;
    public static final short SLOT_CAN = 1;
    public static final short SLOT_INPUT = 2;
    @EntityNetData
    public TankSlot resourceTank = new TankSlot(10000);
    @EntityNetData
    public TankSlot productTank = new TankSlot(10000);
    private ur[] inventoryStacks = new ur[3];
    private Recipe currentRecipe;
    private LiquidStack bufferedLiquid;
    public int distillationTime = 0;
    public int distillationTotalTime = 0;

    public MachineStill(TileMachine tile) {
        super(tile);
        this.setHints((String[])Config.hints.get("still"));
    }

    @Override
    public String getName() {
        return StringUtil.localize("tile.machine.1");
    }

    @Override
    public void openGui(qx player, la tile) {
        player.openGui(ForestryAPI.instance, GuiId.StillGUI.ordinal(), player.p, this.tile.l, this.tile.m, this.tile.n);
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("DistillationTime", this.distillationTime);
        nbttagcompound.a("DistillationTotalTime", this.distillationTotalTime);
        bq NBTresourceSlot = new bq();
        bq NBTproductSlot = new bq();
        this.resourceTank.writeToNBT(NBTresourceSlot);
        this.productTank.writeToNBT(NBTproductSlot);
        nbttagcompound.a("ResourceTank", (cd)NBTresourceSlot);
        nbttagcompound.a("ProductTank", (cd)NBTproductSlot);
        by nbttaglist = new by();
        for (int i = 0; i < this.inventoryStacks.length; ++i) {
            if (this.inventoryStacks[i] == null) continue;
            bq nbttagcompound1 = new bq();
            nbttagcompound1.a("Slot", (byte)i);
            this.inventoryStacks[i].b(nbttagcompound1);
            nbttaglist.a((cd)nbttagcompound1);
        }
        nbttagcompound.a("Items", (cd)nbttaglist);
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.distillationTime = nbttagcompound.e("DistillationTime");
        this.distillationTotalTime = nbttagcompound.e("DistillationTotalTime");
        this.resourceTank = new TankSlot(10000);
        this.productTank = new TankSlot(10000);
        if (nbttagcompound.b("ResourceTank")) {
            this.resourceTank.readFromNBT(nbttagcompound.l("ResourceTank"));
            this.productTank.readFromNBT(nbttagcompound.l("ProductTank"));
        }
        by nbttaglist = nbttagcompound.m("Items");
        this.inventoryStacks = new ur[this.k_()];
        for (int i = 0; i < nbttaglist.c(); ++i) {
            bq nbttagcompound1 = (bq)nbttaglist.b(i);
            byte byte0 = nbttagcompound1.c("Slot");
            if (byte0 < 0 || byte0 >= this.inventoryStacks.length) continue;
            this.inventoryStacks[byte0] = ur.a((bq)nbttagcompound1);
        }
        this.checkRecipe();
    }

    @Override
    public void updateServerSide() {
        LiquidContainerData container;
        if (this.inventoryStacks[2] != null && (container = LiquidHelper.getLiquidContainer(this.inventoryStacks[2])) != null && RecipeManager.isInput(container.stillLiquid)) {
            this.inventoryStacks[2] = StackUtils.replenishByContainer(this.tile, this.inventoryStacks[2], container, this.resourceTank);
            if (this.inventoryStacks[2].a <= 0) {
                this.inventoryStacks[2] = null;
            }
        }
        if (this.inventoryStacks[1] != null && (container = LiquidHelper.getEmptyContainer(this.inventoryStacks[1], new LiquidStack(this.productTank.liquidId, this.productTank.quantity, this.productTank.liquidMeta))) != null) {
            this.inventoryStacks[0] = this.bottleIntoContainer(this.inventoryStacks[1], this.inventoryStacks[0], container, this.productTank);
            if (this.inventoryStacks[1].a <= 0) {
                this.inventoryStacks[1] = null;
            }
        }
        if (this.tile.k.G() % 20L * 10L != 0L) {
            return;
        }
        this.checkRecipe();
        if (this.getErrorState() == EnumErrorCode.NORECIPE && this.currentRecipe != null) {
            this.setErrorState(EnumErrorCode.OK);
        }
    }

    @Override
    public boolean doWork() {
        this.checkRecipe();
        if (this.distillationTime > 0 && this.currentRecipe != null) {
            this.distillationTime -= this.currentRecipe.input.amount;
            this.addProduct(this.currentRecipe.output.itemID, this.currentRecipe.output.amount);
            this.setErrorState(EnumErrorCode.OK);
            return true;
        }
        if (this.currentRecipe != null && this.productTank.quantity + this.currentRecipe.output.amount <= 10000) {
            int resReq = this.currentRecipe.timePerUnit * this.currentRecipe.input.amount;
            if (this.resourceTank.quantity >= resReq) {
                this.distillationTime = this.distillationTotalTime = resReq;
                this.resourceTank.drain(resReq, true);
                this.bufferedLiquid = new LiquidStack(this.currentRecipe.input.itemID, resReq, this.currentRecipe.input.itemMeta);
                this.setErrorState(EnumErrorCode.OK);
                return true;
            }
            this.setErrorState(EnumErrorCode.NORESOURCE);
        }
        this.bufferedLiquid = null;
        return false;
    }

    private void addProduct(int id, int amount) {
        this.productTank.fill(new LiquidStack(id, amount), true);
        if (this.productTank.quantity > 10000) {
            this.productTank.quantity = 10000;
        }
    }

    public void checkRecipe() {
        Recipe sameRec = RecipeManager.findMatchingRecipe(new LiquidStack(this.resourceTank.liquidId, this.resourceTank.quantity));
        if (sameRec == null && this.bufferedLiquid != null && this.distillationTime > 0) {
            sameRec = RecipeManager.findMatchingRecipe(new LiquidStack(this.bufferedLiquid.itemID, this.distillationTime, this.bufferedLiquid.itemMeta));
        }
        if (sameRec == null) {
            this.setErrorState(EnumErrorCode.NORECIPE);
        }
        if (this.currentRecipe != sameRec) {
            this.currentRecipe = sameRec;
            this.resetRecipe();
        }
    }

    private void resetRecipe() {
    }

    @Override
    public boolean isWorking() {
        return this.distillationTime > 0 || this.currentRecipe != null && this.productTank.quantity + this.currentRecipe.output.amount <= 10000;
    }

    @Override
    public boolean hasWork() {
        if (this.currentRecipe == null) {
            return false;
        }
        return (this.distillationTime > 0 || this.resourceTank.quantity >= this.currentRecipe.timePerUnit * this.currentRecipe.input.amount) && this.productTank.quantity <= this.productTank.capacity - this.currentRecipe.output.amount;
    }

    public int getDistillationProgressScaled(int i) {
        if (this.distillationTotalTime == 0) {
            return i;
        }
        return this.distillationTime * i / this.distillationTotalTime;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.quantity * i / 10000;
    }

    public int getProductScaled(int i) {
        return this.productTank.quantity * i / 10000;
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return Utils.rateTankLevel(this.getResourceScaled(100));
    }

    @Override
    public EnumTankLevel getSecondaryLevel() {
        return Utils.rateTankLevel(this.getProductScaled(100));
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.distillationTime = j;
                break;
            }
            case 1: {
                this.distillationTotalTime = j;
                break;
            }
            case 2: {
                this.resourceTank.liquidId = j;
                break;
            }
            case 3: {
                this.resourceTank.quantity = j;
                break;
            }
            case 4: {
                this.productTank.liquidId = j;
                break;
            }
            case 5: {
                this.productTank.quantity = j;
                break;
            }
            case 6: {
                this.productTank.liquidMeta = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(rq container, rw iCrafting) {
        iCrafting.a(container, 0, this.distillationTime);
        iCrafting.a(container, 1, this.distillationTotalTime);
        iCrafting.a(container, 2, this.resourceTank.liquidId);
        iCrafting.a(container, 3, this.resourceTank.quantity);
        iCrafting.a(container, 4, this.productTank.liquidId);
        iCrafting.a(container, 5, this.productTank.quantity);
        iCrafting.a(container, 6, this.productTank.liquidMeta);
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        int inventory;
        LiquidContainerData container = LiquidHelper.getLiquidContainer(stack);
        if (container != null && RecipeManager.isInput(container.stillLiquid)) {
            inventory = 2;
        } else if (LiquidHelper.isEmptyContainer(stack)) {
            inventory = 1;
        } else {
            return 0;
        }
        if (this.inventoryStacks[inventory] == null) {
            if (doAdd) {
                this.inventoryStacks[inventory] = stack.l();
            }
            return stack.a;
        }
        if (!this.inventoryStacks[inventory].a(stack)) {
            return 0;
        }
        int space = this.inventoryStacks[inventory].d() - this.inventoryStacks[inventory].a;
        if (space <= 0) {
            return 0;
        }
        if (doAdd) {
            this.inventoryStacks[inventory].a += stack.a;
        }
        return Math.min(space, stack.a);
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        ur product = null;
        if (this.inventoryStacks[0] != null) {
            product = new ur(this.inventoryStacks[0].c, 1, this.inventoryStacks[0].j());
            if (doRemove) {
                --this.inventoryStacks[0].a;
                if (this.inventoryStacks[0].a <= 0) {
                    this.inventoryStacks[0] = null;
                }
            }
        }
        if (product != null) {
            return new ur[]{product};
        }
        return new ur[0];
    }

    @Override
    public int k_() {
        return this.inventoryStacks.length;
    }

    @Override
    public ur a(int i) {
        return this.inventoryStacks[i];
    }

    @Override
    public ur a(int i, int j) {
        if (this.inventoryStacks[i] == null) {
            return null;
        }
        if (this.inventoryStacks[i].a <= j) {
            ur removed = this.inventoryStacks[i];
            this.inventoryStacks[i] = null;
            return removed;
        }
        ur removed = this.inventoryStacks[i].a(j);
        if (this.inventoryStacks[i].a == 0) {
            this.inventoryStacks[i] = null;
        }
        return removed;
    }

    @Override
    public void a(int i, ur itemstack) {
        this.inventoryStacks[i] = itemstack;
        if (itemstack != null && itemstack.a > this.tile.c()) {
            itemstack.a = this.tile.c();
        }
    }

    @Override
    public ur a_(int slot) {
        if (this.inventoryStacks[slot] == null) {
            return null;
        }
        ur toReturn = this.inventoryStacks[slot];
        this.inventoryStacks[slot] = null;
        return toReturn;
    }

    @Override
    public int getStartInventorySide(int side) {
        switch (side) {
            case 0: 
            case 1: {
                return 0;
            }
            case 2: 
            case 3: {
                return 2;
            }
        }
        return 1;
    }

    @Override
    public int getSizeInventorySide(int side) {
        return 1;
    }

    @Override
    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (this.resourceTank.quantity > 0 && this.resourceTank.liquidId != resource.itemID) {
            return 0;
        }
        if (!RecipeManager.isInput(resource)) {
            return 0;
        }
        int used = this.resourceTank.fill(resource, doFill);
        if (doFill && used > 0) {
            this.tile.sendNetworkUpdate();
        }
        return used;
    }

    @Override
    public LiquidStack drain(ForgeDirection from, int quantityMax, boolean doEmpty) {
        return this.drain(1, quantityMax, doEmpty);
    }

    @Override
    public LiquidStack drain(int tankIndex, int quantityMax, boolean doEmpty) {
        if (tankIndex != 1) {
            return null;
        }
        return this.productTank.drain(quantityMax, doEmpty);
    }

    public TankSlot[] getTanks(ForgeDirection direction) {
        return new TankSlot[]{this.resourceTank, this.productTank};
    }

    @Override
    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        if (direction == this.tile.getOrientation().getRotation(ForgeDirection.UP)) {
            return this.resourceTank;
        }
        if (direction == this.tile.getOrientation().getRotation(ForgeDirection.DOWN)) {
            return this.productTank;
        }
        return null;
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.hasWork);
        return res;
    }

    public static void initialize() {
        RecipeManagers.stillManager.addRecipe(100, new LiquidStack(ForestryItem.liquidBiomass, 10), new LiquidStack(ForestryItem.liquidBiofuel, 3));
    }

    public static class RecipeManager
    implements IStillManager {
        public static ArrayList recipes = new ArrayList();

        @Override
        public void addRecipe(int timePerUnit, LiquidStack input, LiquidStack output) {
            recipes.add(new Recipe(timePerUnit, input, output));
        }

        public static Recipe findMatchingRecipe(LiquidStack item) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.matches(item)) continue;
                return recipe;
            }
            return null;
        }

        public static boolean isInput(LiquidStack res) {
            return RecipeManager.findMatchingRecipe(res) != null;
        }

        @Override
        public List getRecipes() {
            HashMap<ur[], ur[]> recipeList = new HashMap<ur[], ur[]>();
            for (Recipe recipe : recipes) {
                recipeList.put(new ur[]{recipe.input.asItemStack()}, new ur[]{recipe.output.asItemStack()});
            }
            return (List)((Object)recipeList);
        }
    }

    public static class Recipe {
        public final int timePerUnit;
        public final LiquidStack input;
        public final LiquidStack output;

        public Recipe(int timePerUnit, LiquidStack input, LiquidStack output) {
            this.timePerUnit = timePerUnit;
            this.input = input;
            this.output = output;
        }

        public boolean matches(LiquidStack res) {
            if (res == null && this.input == null) {
                return true;
            }
            if (res == null && this.input != null) {
                return false;
            }
            if (res != null && this.input == null) {
                return false;
            }
            return this.input.isLiquidEqual(res);
        }
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(any tile) {
            return new MachineStill((TileMachine)tile);
        }
    }
}

