/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gadgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.gadgets.BlockStructure;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StackUtils;
import forestry.farming.gadgets.TileControl;
import forestry.farming.gadgets.TileFarm;
import forestry.farming.gadgets.TileFarmPlain;
import forestry.farming.gadgets.TileGearbox;
import forestry.farming.gadgets.TileHatch;
import forestry.farming.gadgets.TileValve;
import java.util.ArrayList;
import java.util.List;

public class BlockFarm
extends BlockStructure {
    public BlockFarm(int id) {
        super(id, agi.e);
        this.c(1.0f);
        this.setTextureFile("/gfx/forestry/blocks/farm.png");
    }

    @SideOnly(value=Side.CLIENT)
    public void a(int id, tj tab, List list) {
        for (int i = 0; i < 6; ++i) {
            if (i == 1) continue;
            for (TileFarm.EnumFarmBlock block : TileFarm.EnumFarmBlock.values()) {
                ur stack = new ur(id, 1, i);
                bq compound = new bq("tag");
                block.saveToCompound(compound);
                stack.d(compound);
                list.add(stack);
            }
        }
    }

    @Override
    public boolean removeBlockByPlayer(yc world, qx player, int x2, int y2, int z2) {
        any tile;
        int meta = world.h(x2, y2, z2);
        if (Proxies.common.isSimulating(world) && this.canHarvestBlock(player, meta) && (tile = world.q(x2, y2, z2)) instanceof TileFarm) {
            TileFarm farm = (TileFarm)tile;
            if (meta == 1) {
                meta = 0;
            }
            ur stack = new ur(this.cm, 1, meta);
            bq compound = new bq("tag");
            farm.getFarmBlock().saveToCompound(compound);
            stack.d(compound);
            StackUtils.dropItemStackAsEntity(stack, world, x2, y2, z2);
        }
        return world.e(x2, y2, z2, 0);
    }

    public ArrayList getBlockDropped(yc world, int x2, int y2, int z2, int metadata, int fortune) {
        return new ArrayList();
    }

    public any createNewTileEntity(yc world, int metadata) {
        switch (metadata) {
            case 2: {
                return new TileGearbox();
            }
            case 3: {
                return new TileHatch();
            }
            case 4: {
                return new TileValve();
            }
            case 5: {
                return new TileControl();
            }
        }
        return new TileFarmPlain();
    }

    public any a(yc world) {
        return this.createNewTileEntity(world, 0);
    }

    public int a(int side, int metadata) {
        int textureShift = 0;
        int sideShift = 0;
        if (metadata == 0 && side == 2) {
            sideShift = 16;
        } else if (metadata == 0 && (side == 0 || side == 1)) {
            sideShift = 32;
        }
        switch (metadata) {
            case 2: {
                textureShift = TileGearbox.TEXTURE_SHIFT;
                break;
            }
            case 3: {
                textureShift = TileHatch.TEXTURE_SHIFT;
                break;
            }
            case 4: {
                textureShift = TileValve.TEXTURE_SHIFT;
                break;
            }
            case 5: {
                textureShift = TileControl.TEXTURE_SHIFT;
            }
        }
        return textureShift + sideShift;
    }

    public boolean canConnectRedstone(ym world, int x2, int y2, int z2, int side) {
        return world.h(x2, y2, z2) == 5;
    }

    public int d(ym world, int x2, int y2, int z2, int side) {
        any tile = world.q(x2, y2, z2);
        if (tile == null || !(tile instanceof TileFarm)) {
            return amq.ao.a(side, 0);
        }
        return ((TileFarm)tile).getBlockTexture(side, world.h(x2, y2, z2));
    }
}

