/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gadgets;

import forestry.api.core.ForestryAPI;
import forestry.api.core.IStructureLogic;
import forestry.api.core.ITileStructure;
import forestry.api.farming.Farmables;
import forestry.api.farming.IFarmComponent;
import forestry.api.farming.IFarmListener;
import forestry.core.gadgets.Gadget;
import forestry.core.gadgets.TileForestry;
import forestry.core.network.GuiId;
import forestry.core.network.PacketPayload;
import forestry.core.proxy.Proxies;
import forestry.core.utils.TileInventoryAdapter;
import forestry.core.utils.Utils;

public abstract class TileFarm
extends TileForestry
implements IFarmComponent {
    EnumFarmBlock farmBlock = EnumFarmBlock.BRICK_STONE;
    int textureShift = 0;
    protected TileInventoryAdapter inventory;
    IStructureLogic structureLogic = Farmables.farmInterface.createFarmStructureLogic(this);
    private boolean isMaster;
    private int masterX;
    private int masterZ;
    private int masterY = -99;

    @Override
    public void openGui(qx player) {
        if (this.isMaster()) {
            player.openGui(ForestryAPI.instance, GuiId.MultiFarmGUI.ordinal(), this.k, this.l, this.m, this.n);
        } else if (this.hasMaster()) {
            player.openGui(ForestryAPI.instance, GuiId.MultiFarmGUI.ordinal(), this.k, this.masterX, this.masterY, this.masterZ);
        }
    }

    @Override
    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        this.isMaster = nbttagcompound.n("IsMaster");
        this.masterX = nbttagcompound.e("MasterX");
        this.masterY = nbttagcompound.e("MasterY");
        this.masterZ = nbttagcompound.e("MasterZ");
        this.farmBlock = EnumFarmBlock.getFromCompound(nbttagcompound);
        if (this.isMaster) {
            this.makeMaster();
        }
        if (this.inventory != null) {
            this.inventory.readFromNBT(nbttagcompound);
        }
        this.structureLogic.readFromNBT(nbttagcompound);
    }

    @Override
    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("IsMaster", this.isMaster);
        nbttagcompound.a("MasterX", this.masterX);
        nbttagcompound.a("MasterY", this.masterY);
        nbttagcompound.a("MasterZ", this.masterZ);
        this.farmBlock.saveToCompound(nbttagcompound);
        if (this.inventory != null) {
            this.inventory.writeToNBT(nbttagcompound);
        }
        this.structureLogic.writeToNBT(nbttagcompound);
    }

    @Override
    public void initialize() {
    }

    @Override
    public void g() {
        if (!Proxies.common.isSimulating(this.k)) {
            this.updateClientSide();
        } else {
            if (!this.isInited) {
                this.initialize();
                this.isInited = true;
            }
            if (this.k.G() % 200L == 0L && (!this.isIntegratedIntoStructure() || this.isMaster())) {
                this.validateStructure();
            }
            this.updateServerSide();
        }
    }

    protected void updateServerSide() {
    }

    protected void updateClientSide() {
    }

    public void setFarmBlock(EnumFarmBlock block) {
        this.farmBlock = block;
        this.sendNetworkUpdate();
    }

    public EnumFarmBlock getFarmBlock() {
        return this.farmBlock;
    }

    public int getBlockTexture(int side, int meta) {
        if (meta == 1) {
            return 48 + this.farmBlock.getColumn();
        }
        int sideShift = 0;
        if (meta == 0 && side == 2) {
            sideShift = 16;
        } else if (meta == 0 && (side == 0 || side == 1)) {
            sideShift = 32;
        }
        return this.textureShift + sideShift + this.farmBlock.getColumn();
    }

    protected abstract void createInventory();

    @Override
    public Gadget getMachine() {
        return null;
    }

    @Override
    public PacketPayload getPacketPayload() {
        PacketPayload payload = new PacketPayload(0, 1);
        payload.shortPayload[0] = (short)this.farmBlock.ordinal();
        return payload;
    }

    @Override
    public void fromPacketPayload(PacketPayload payload) {
        this.farmBlock = EnumFarmBlock.values()[payload.shortPayload[0]];
        this.k.o(this.l, this.m, this.n);
    }

    @Override
    public String getTypeUID() {
        return this.structureLogic.getTypeUID();
    }

    @Override
    public void validateStructure() {
        this.structureLogic.validateStructure();
    }

    @Override
    public void makeMaster() {
        this.setCentralTE(null);
        this.isMaster = true;
        if (this.inventory == null) {
            this.createInventory();
        }
    }

    @Override
    public void onStructureReset() {
        this.setCentralTE(null);
        if (this.k.h(this.l, this.m, this.n) == 1) {
            this.k.d(this.l, this.m, this.n, 0);
        }
        this.isMaster = false;
        this.k.i(this.l, this.m, this.n);
    }

    @Override
    public ITileStructure getCentralTE() {
        if (!this.isIntegratedIntoStructure()) {
            return null;
        }
        if (!this.isMaster) {
            any tile = this.k.q(this.masterX, this.masterY, this.masterZ);
            if (tile instanceof ITileStructure) {
                ITileStructure master = (ITileStructure)this.k.q(this.masterX, this.masterY, this.masterZ);
                if (master.isMaster()) {
                    return master;
                }
                return null;
            }
            return null;
        }
        return this;
    }

    private boolean isSameTile(any tile) {
        return tile.l == this.l && tile.m == this.m && tile.n == this.n;
    }

    @Override
    public void setCentralTE(any tile) {
        if (tile == null || tile == this || this.isSameTile(tile)) {
            this.masterZ = 0;
            this.masterX = 0;
            this.masterY = -99;
            return;
        }
        this.isMaster = false;
        this.masterX = tile.l;
        this.masterY = tile.m;
        this.masterZ = tile.n;
        this.k.i(this.l, this.m, this.n);
    }

    @Override
    public boolean isMaster() {
        return this.isMaster;
    }

    protected boolean hasMaster() {
        return this.masterY >= 0;
    }

    @Override
    public la getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isIntegratedIntoStructure() {
        return this.isMaster || this.masterY >= 0;
    }

    @Override
    public void registerListener(IFarmListener listener) {
    }

    @Override
    public void removeListener(IFarmListener listener) {
    }

    @Override
    public String b() {
        return "Farm";
    }

    @Override
    public boolean a_(qx player) {
        return Utils.isUseableByPlayer(player, this, this.k, this.l, this.m, this.n);
    }

    public static enum EnumFarmBlock {
        BRICK_STONE(0),
        BRICK_MOSSY(1),
        BRICK_CRACKED(2),
        BRICK(3),
        SANDSTONE_SMOOTH(4),
        SANDSTONE_CHISELED(5),
        BRICK_NETHER(6),
        BRICK_CHISELED(7);

        private final int textureColumn;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private EnumFarmBlock() {
            void textureColumn;
            this.textureColumn = textureColumn;
        }

        public int getColumn() {
            return this.textureColumn;
        }

        public void saveToCompound(bq compound) {
            compound.a("FarmBlock", this.ordinal());
        }

        public String getName() {
            switch (this) {
                case BRICK_MOSSY: {
                    return up.e[amq.bp.cm].l(new ur(amq.bp, 1, 1));
                }
                case BRICK_CRACKED: {
                    return up.e[amq.bp.cm].l(new ur(amq.bp, 1, 2));
                }
                case BRICK_CHISELED: {
                    return up.e[amq.bp.cm].l(new ur(amq.bp, 1, 3));
                }
                case BRICK: {
                    return up.e[amq.ao.cm].l(new ur(amq.ao));
                }
                case SANDSTONE_SMOOTH: {
                    return up.e[amq.T.cm].l(new ur(amq.T, 1, 2));
                }
                case SANDSTONE_CHISELED: {
                    return up.e[amq.T.cm].l(new ur(amq.T, 1, 1));
                }
                case BRICK_NETHER: {
                    return up.e[amq.bD.cm].l(new ur(amq.bD));
                }
            }
            return up.e[amq.bp.cm].l(new ur(amq.bp, 1, 0));
        }

        public ur getCraftingIngredient() {
            switch (this) {
                case BRICK_MOSSY: {
                    return new ur(amq.bp, 1, 1);
                }
                case BRICK_CRACKED: {
                    return new ur(amq.bp, 1, 2);
                }
                case BRICK_CHISELED: {
                    return new ur(amq.bp, 1, 3);
                }
                case BRICK: {
                    return new ur(amq.ao, 1);
                }
                case SANDSTONE_SMOOTH: {
                    return new ur(amq.T, 1, 2);
                }
                case SANDSTONE_CHISELED: {
                    return new ur(amq.T, 1, 1);
                }
                case BRICK_NETHER: {
                    return new ur(amq.bD, 1);
                }
            }
            return new ur(amq.bp, 1, 0);
        }

        public static EnumFarmBlock getFromCompound(bq compound) {
            int farmBlockOrdinal;
            if (compound != null && (farmBlockOrdinal = compound.e("FarmBlock")) < EnumFarmBlock.values().length) {
                return EnumFarmBlock.values()[farmBlockOrdinal];
            }
            return BRICK_STONE;
        }
    }
}

