/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gadgets;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import forestry.api.core.ITileStructure;
import forestry.api.farming.IFarmHousing;
import forestry.core.GameMode;
import forestry.farming.gadgets.TileFarm;

public class TileGearbox
extends TileFarm
implements IPowerReceptor {
    public static int MIN_ENERGY_RECEIVED = 5;
    public static int MAX_ENERGY_RECEIVED = 75;
    public static int MIN_ACTIVATION_ENERGY = 150;
    public static int MAX_ENERGY = 1050;
    public static int TEXTURE_SHIFT = 64;
    private int activationDelay = 0;
    private int previousDelays = 0;
    IPowerProvider powerProvider = PowerFramework.currentFramework.createPowerProvider();

    public TileGearbox() {
        this.powerProvider.configure(1000, MIN_ENERGY_RECEIVED, Math.round((float)MAX_ENERGY_RECEIVED * GameMode.getGameMode().getEnergyDemandModifier()), Math.round((float)MIN_ACTIVATION_ENERGY * GameMode.getGameMode().getEnergyDemandModifier()), Math.round((float)MAX_ENERGY * GameMode.getGameMode().getEnergyDemandModifier()));
        this.textureShift = TEXTURE_SHIFT;
    }

    @Override
    protected void createInventory() {
    }

    @Override
    public boolean hasFunction() {
        return true;
    }

    @Override
    protected void updateServerSide() {
        if (this.powerProvider != null) {
            this.powerProvider.update(this);
        }
    }

    @Override
    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        PowerFramework.currentFramework.loadPowerProvider(this, nbttagcompound);
        this.activationDelay = nbttagcompound.e("ActivationDelay");
        this.previousDelays = nbttagcompound.e("PrevDelays");
    }

    @Override
    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        PowerFramework.currentFramework.savePowerProvider(this, nbttagcompound);
        nbttagcompound.a("ActivationDelay", this.activationDelay);
        nbttagcompound.a("PrevDelays", this.previousDelays);
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public void doWork() {
        if (this.activationDelay > 0) {
            --this.activationDelay;
            return;
        }
        if (this.k.G() % 5L * 10L != 0L) {
            return;
        }
        ITileStructure central = this.getCentralTE();
        if (!(central instanceof IFarmHousing)) {
            return;
        }
        if (((IFarmHousing)((Object)central)).doWork()) {
            this.powerProvider.useEnergy(MIN_ACTIVATION_ENERGY, MIN_ACTIVATION_ENERGY, true);
            this.previousDelays = 0;
        } else {
            this.activationDelay = 10 * this.previousDelays < 120 ? 10 * this.previousDelays : 120;
            ++this.previousDelays;
        }
    }

    @Override
    public int powerRequest() {
        if (this.getPowerProvider().getEnergyStored() >= (float)this.getPowerProvider().getMaxEnergyStored()) {
            return 0;
        }
        if (!this.isIntegratedIntoStructure()) {
            return 0;
        }
        if (this.getCentralTE() == null) {
            return 0;
        }
        return this.getPowerProvider().getMaxEnergyReceived();
    }
}

