/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.Farmables;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.core.utils.Vect;
import forestry.farming.logic.FarmLogic;
import java.util.Collection;
import java.util.Stack;
import net.minecraftforge.common.ForgeDirection;

public class FarmLogicGourd
extends FarmLogic {
    private IFarmable[] seeds = ((Collection)Farmables.farmables.get("farmGourd")).toArray(new IFarmable[0]);

    public FarmLogicGourd(IFarmHousing housing) {
        super(housing);
    }

    @Override
    public int getIconIndex() {
        return up.bf.b(0);
    }

    @Override
    public String getTextureFile() {
        return "/gui/items.png";
    }

    @Override
    public String getName() {
        return "Gourd Farm";
    }

    @Override
    public int getFertilizerConsumption() {
        return 10;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return (int)(40.0f * hydrationModifier);
    }

    @Override
    public boolean isAcceptedResource(ur itemstack) {
        return false;
    }

    @Override
    public boolean isAcceptedGermling(ur itemstack) {
        return false;
    }

    @Override
    public Collection collect() {
        return null;
    }

    @Override
    public boolean cultivate(int x2, int y2, int z2, ForgeDirection direction, int extent) {
        return false;
    }

    @Override
    public Collection harvest(int x2, int y2, int z2, ForgeDirection direction, int extent) {
        this.world = this.housing.getWorld();
        Stack<ICrop> crops = new Stack<ICrop>();
        for (int i = 0; i < extent; ++i) {
            Vect position = this.translateWithOffset(x2, y2 + 1, z2, direction, i);
            for (IFarmable seed : this.seeds) {
                ICrop crop = seed.getCropAt(this.world, position.x, position.y, position.z);
                if (crop == null) continue;
                crops.push(crop);
            }
        }
        return crops;
    }
}

