/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.Farmables;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.core.utils.Utils;
import forestry.core.utils.Vect;
import forestry.farming.logic.FarmLogicHomogenous;
import java.util.Collection;
import java.util.Stack;
import net.minecraftforge.common.ForgeDirection;

public class FarmLogicInfernal
extends FarmLogicHomogenous {
    public FarmLogicInfernal(IFarmHousing housing) {
        super(housing, new ur[]{new ur(amq.bf)}, new ur[]{new ur(amq.bf)}, new ur[0], ((Collection)Farmables.farmables.get("farmInfernal")).toArray(new IFarmable[0]));
    }

    @Override
    public String getName() {
        return "Managed Infernal Farm";
    }

    @Override
    public int getIconIndex() {
        return up.br.b(0);
    }

    @Override
    public String getTextureFile() {
        return "/gui/items.png";
    }

    @Override
    public int getFertilizerConsumption() {
        return 20;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return 0;
    }

    @Override
    public Collection collect() {
        return null;
    }

    @Override
    public Collection harvest(int x2, int y2, int z2, ForgeDirection direction, int extent) {
        this.world = this.housing.getWorld();
        Stack<ICrop> crops = new Stack<ICrop>();
        for (int i = 0; i < extent; ++i) {
            Vect position = this.translateWithOffset(x2, y2 + 1, z2, direction, i);
            for (IFarmable farmable : this.germlings) {
                ICrop crop = farmable.getCropAt(this.world, position.x, position.y, position.z);
                if (crop == null) continue;
                crops.push(crop);
            }
        }
        return crops;
    }

    @Override
    protected boolean maintainGermlings(int x2, int y2, int z2, ForgeDirection direction, int extent) {
        for (int i = 0; i < extent; ++i) {
            Vect position = this.translateWithOffset(x2, y2, z2, direction, i);
            if (!this.isAirBlock(position) && !Utils.isReplaceableBlock(this.world, position.x, position.y, position.z)) continue;
            ur below = this.getAsItemStack(position.add(new Vect(0, -1, 0)));
            if (this.ground[0].c != below.c) continue;
            return this.trySetCrop(position);
        }
        return false;
    }

    private boolean trySetCrop(Vect position) {
        for (IFarmable candidate : this.germlings) {
            if (!this.housing.plantGermling(candidate, this.world, position.x, position.y, position.z)) continue;
            return true;
        }
        return false;
    }
}

