/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.IFarmHousing;
import forestry.core.config.ForestryBlock;
import forestry.core.utils.Vect;
import forestry.farming.logic.CropPeat;
import forestry.farming.logic.FarmLogicWatered;
import java.util.Collection;
import java.util.Stack;
import net.minecraftforge.common.ForgeDirection;

public class FarmLogicPeat
extends FarmLogicWatered {
    public FarmLogicPeat(IFarmHousing housing) {
        super(housing, new ur[]{new ur(ForestryBlock.soil.cm, 1, 1)}, new ur[]{new ur(ForestryBlock.soil.cm, 1, 1)}, new ur[]{new ur(amq.y), new ur((amq)amq.x)});
    }

    @Override
    public int getFertilizerConsumption() {
        return 5;
    }

    @Override
    public String getName() {
        if (this.isManual) {
            return "Manual Peat Bog";
        }
        return "Managed Peat Bog";
    }

    @Override
    public boolean isAcceptedGermling(ur itemstack) {
        return false;
    }

    @Override
    public Collection harvest(int x2, int y2, int z2, ForgeDirection direction, int extent) {
        this.world = this.housing.getWorld();
        Stack<CropPeat> crops = new Stack<CropPeat>();
        for (int i = 0; i < extent; ++i) {
            Vect position = this.translateWithOffset(x2, y2, z2, direction, i);
            ur occupant = this.getAsItemStack(position);
            if (occupant.c != ForestryBlock.soil.cm) continue;
            int type = occupant.j() & 3;
            int maturity = occupant.j() >> 2;
            if (type != 1 || maturity < 3) continue;
            crops.push(new CropPeat(this.world, position));
        }
        return crops;
    }

    @Override
    public int getIconIndex() {
        return 16;
    }

    @Override
    public String getTextureFile() {
        return "/gfx/forestry/items/items.png";
    }
}

