/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.IFarmHousing;
import forestry.core.proxy.Proxies;
import forestry.core.utils.Vect;
import forestry.farming.logic.CropRubber;
import forestry.farming.logic.FarmLogic;
import forestry.plugins.PluginIC2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Stack;
import net.minecraftforge.common.ForgeDirection;

public class FarmLogicRubber
extends FarmLogic {
    private boolean inActive;
    private HashMap lastExtents = new HashMap();

    public FarmLogicRubber(IFarmHousing housing) {
        super(housing);
        if (PluginIC2.rubberwood == null || PluginIC2.resin == null) {
            Proxies.log.warning("Failed to init a farm logic %s since IC2 was not found", (Object)this.getClass().getName());
            this.inActive = true;
        }
    }

    @Override
    public int getIconIndex() {
        if (!this.inActive) {
            return PluginIC2.resin.c();
        }
        return up.M.b(0);
    }

    @Override
    public String getTextureFile() {
        if (!this.inActive) {
            return PluginIC2.resin.b().getTextureFile();
        }
        return "/gui/items.png";
    }

    @Override
    public String getName() {
        return "Rubber Plantation";
    }

    @Override
    public int getFertilizerConsumption() {
        return 40;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return (int)(5.0f * hydrationModifier);
    }

    @Override
    public boolean isAcceptedResource(ur itemstack) {
        return false;
    }

    @Override
    public boolean isAcceptedGermling(ur itemstack) {
        return false;
    }

    @Override
    public Collection collect() {
        return null;
    }

    @Override
    public boolean cultivate(int x2, int y2, int z2, ForgeDirection direction, int extent) {
        return false;
    }

    @Override
    public Collection harvest(int x2, int y2, int z2, ForgeDirection direction, int extent) {
        int lastExtent;
        if (this.inActive) {
            return null;
        }
        this.world = this.housing.getWorld();
        Collection crops = null;
        Vect start = new Vect(x2, y2, z2);
        if (!this.lastExtents.containsKey(start)) {
            this.lastExtents.put(start, 0);
        }
        if ((lastExtent = ((Integer)this.lastExtents.get(start)).intValue()) > extent) {
            lastExtent = 0;
        }
        Vect position = this.translateWithOffset(x2, y2 + 1, z2, direction, lastExtent);
        crops = this.getHarvestBlocks(position);
        this.lastExtents.put(start, ++lastExtent);
        return crops;
    }

    private Collection getHarvestBlocks(Vect position) {
        ArrayList seen = new ArrayList();
        Stack<CropRubber> crops = new Stack<CropRubber>();
        int blockid = this.getBlockId(position);
        if (blockid != PluginIC2.rubberwood.c) {
            return crops;
        }
        int meta = this.getBlockMeta(position);
        if (meta >= 2 && meta <= 5) {
            crops.push(new CropRubber(this.world, blockid, meta, position));
        }
        ArrayList candidates = this.processHarvestBlock(crops, seen, position);
        ArrayList temp = new ArrayList();
        while (!candidates.isEmpty() && crops.size() < 100) {
            for (Vect candidate : candidates) {
                temp.addAll(this.processHarvestBlock(crops, seen, candidate));
            }
            candidates.clear();
            candidates.addAll(temp);
            temp.clear();
        }
        return crops;
    }

    private ArrayList processHarvestBlock(Stack crops, Collection seen, Vect position) {
        ArrayList<Vect> candidates = new ArrayList<Vect>();
        for (int i = -1; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    int blockid;
                    Vect candidate = new Vect(position.x + i, position.y + j, position.z + k);
                    if (candidate.equals(position)) continue;
                    boolean skip = false;
                    for (Vect prcs : seen) {
                        if (!candidate.equals(prcs)) continue;
                        skip = true;
                        break;
                    }
                    if (skip || (blockid = this.getBlockId(candidate)) != PluginIC2.rubberwood.c) continue;
                    int meta = this.getBlockMeta(candidate);
                    if (meta >= 2 && meta <= 5) {
                        crops.push(new CropRubber(this.world, blockid, meta, candidate));
                    }
                    candidates.add(candidate);
                    seen.add(candidate);
                }
            }
        }
        return candidates;
    }
}

