/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.Farmables;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.core.utils.Vect;
import forestry.farming.logic.FarmLogic;
import java.util.Collection;
import java.util.Stack;
import net.minecraftforge.common.ForgeDirection;

public class FarmLogicSucculent
extends FarmLogic {
    IFarmable[] germlings = ((Collection)Farmables.farmables.get("farmSucculentes")).toArray(new IFarmable[0]);

    public FarmLogicSucculent(IFarmHousing housing) {
        super(housing);
    }

    @Override
    public int getIconIndex() {
        return up.aW.b(2);
    }

    @Override
    public String getTextureFile() {
        return "/gui/items.png";
    }

    @Override
    public String getName() {
        if (this.isManual) {
            return "Manual Succulent Farm";
        }
        return "Managed Succulent Farm";
    }

    @Override
    public int getFertilizerConsumption() {
        return 10;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return 1;
    }

    @Override
    public boolean isAcceptedResource(ur itemstack) {
        if (this.isManual) {
            return false;
        }
        return itemstack.c == amq.H.cm;
    }

    @Override
    public boolean isAcceptedGermling(ur itemstack) {
        if (this.isManual) {
            return false;
        }
        return itemstack.c == amq.aY.cm;
    }

    @Override
    public Collection collect() {
        return null;
    }

    @Override
    public boolean cultivate(int x2, int y2, int z2, ForgeDirection direction, int extent) {
        return false;
    }

    @Override
    public Collection harvest(int x2, int y2, int z2, ForgeDirection direction, int extent) {
        this.world = this.housing.getWorld();
        Stack<ICrop> crops = new Stack<ICrop>();
        for (int i = 0; i < extent; ++i) {
            Vect position = this.translateWithOffset(x2, y2 + 1, z2, direction, i);
            for (IFarmable seed : this.germlings) {
                ICrop crop = seed.getCropAt(this.world, position.x, position.y, position.z);
                if (crop == null) continue;
                crops.push(crop);
            }
        }
        return crops;
    }
}

