/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.core.utils.Vect;
import forestry.farming.logic.CropBlock;

public class FarmableStacked
implements IFarmable {
    int blockid;
    int matureHeight;

    public FarmableStacked(int blockid, int matureHeight) {
        this.blockid = blockid;
        this.matureHeight = matureHeight;
    }

    @Override
    public boolean isSaplingAt(yc world, int x2, int y2, int z2) {
        return world.a(x2, y2, z2) == this.blockid;
    }

    @Override
    public ICrop getCropAt(yc world, int x2, int y2, int z2) {
        if (world.a(x2, y2 + (this.matureHeight - 1), z2) != this.blockid) {
            return null;
        }
        return new CropBlock(world, this.blockid, 0, new Vect(x2, y2 + (this.matureHeight - 1), z2));
    }

    @Override
    public boolean isGermling(ur itemstack) {
        return itemstack.c == this.blockid;
    }

    @Override
    public boolean plantSaplingAt(ur germling, yc world, int x2, int y2, int z2) {
        return world.e(x2, y2, z2, this.blockid);
    }

    @Override
    public boolean isWindfall(ur itemstack) {
        return false;
    }
}

