/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.triggers;

import buildcraft.api.gates.ITriggerParameter;
import forestry.api.core.ITileStructure;
import forestry.core.triggers.Trigger;
import forestry.core.utils.StringUtil;
import forestry.farming.gadgets.TileFarmPlain;
import forestry.farming.gadgets.TileHatch;

public class TriggerLowFertilizer
extends Trigger {
    private float threshold;

    public TriggerLowFertilizer(int id, float threshold) {
        super(id, 0);
        this.threshold = threshold;
    }

    @Override
    public String getDescription() {
        return StringUtil.localize("trigger.lowFertilizer") + " < " + this.threshold * 100.0f + "%";
    }

    @Override
    public boolean isTriggerActive(any tile, ITriggerParameter parameter) {
        if (!(tile instanceof TileHatch)) {
            return false;
        }
        ITileStructure central = ((TileHatch)tile).getCentralTE();
        if (central == null || !(central instanceof TileFarmPlain)) {
            return false;
        }
        ur fertilizer = central.getInventory().a(20);
        if (fertilizer == null) {
            return true;
        }
        return (float)fertilizer.a / (float)fertilizer.d() <= this.threshold;
    }
}

