/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gadgets;

import forestry.api.core.ForestryAPI;
import forestry.core.config.Config;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.TileMachine;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.triggers.Trigger;
import forestry.core.utils.GenericInventoryAdapter;
import forestry.core.utils.StringUtil;
import forestry.mail.EnumDeliveryState;
import forestry.mail.ILetter;
import forestry.mail.IMailContainer;
import forestry.mail.IPostalState;
import forestry.mail.PostOffice;
import forestry.mail.items.ItemLetter;
import forestry.plugins.PluginForestryMail;
import java.util.LinkedList;
import net.minecraftforge.common.ForgeDirection;

public class MachineMailbox
extends Machine
implements IMailContainer {
    private boolean isLinked = false;

    public MachineMailbox(TileMachine tile) {
        super(tile);
        this.setHints((String[])Config.hints.get("mailbox"));
    }

    @Override
    public String getName() {
        return "tile.mill.5";
    }

    @Override
    public void openGui(qx player, la tile) {
        if (!Proxies.common.isSimulating(this.tile.k)) {
            return;
        }
        ur held = player.bS();
        if (ItemLetter.isLetter(held)) {
            IPostalState result = this.tryDispatchLetter(held, true);
            if (!result.isOk()) {
                player.b(StringUtil.localize("chat.mail." + result.getIdentifier()));
            } else {
                --held.a;
            }
        } else {
            player.openGui(ForestryAPI.instance, GuiId.MailboxGUI.ordinal(), player.p, this.tile.l, this.tile.m, this.tile.n);
        }
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        nbttagcompound.a("LNK", this.isLinked);
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        this.isLinked = nbttagcompound.n("LNK");
    }

    @Override
    public void updateServerSide() {
        if (!this.isLinked) {
            this.getOrCreateMailInventory();
            this.isLinked = true;
        }
    }

    @Override
    public boolean doWork() {
        return false;
    }

    @Override
    public boolean isWorking() {
        return false;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
    }

    @Override
    public void sendGUINetworkData(rq container, rw iCrafting) {
    }

    public la getOrCreateMailInventory() {
        if (!Proxies.common.isSimulating(this.tile.k)) {
            return new GenericInventoryAdapter(84, "Letters");
        }
        if (this.tile.getOwnerName() == null || this.tile.getOwnerName().isEmpty()) {
            return new GenericInventoryAdapter(84, "Letters");
        }
        return PostOffice.getOrCreatePOBox(this.tile.k, this.tile.getOwnerName());
    }

    private IPostalState tryDispatchLetter(ur letterstack, boolean dispatchLetter) {
        ILetter letter = ItemLetter.getLetter(letterstack);
        IPostalState result = letter != null ? PostOffice.getPostOffice(this.tile.k).lodgeLetter(this.tile.k, letterstack, dispatchLetter) : EnumDeliveryState.NOT_MAILABLE;
        return result;
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        if (!ItemLetter.isLetter(stack)) {
            return 0;
        }
        IPostalState result = this.tryDispatchLetter(stack, doAdd);
        if (!result.isOk()) {
            return 0;
        }
        return 1;
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        ur product = null;
        la mailInventory = this.getOrCreateMailInventory();
        for (int i = 0; i < mailInventory.k_(); ++i) {
            ur slotStack = mailInventory.a(i);
            if (slotStack == null) continue;
            product = slotStack;
            if (!doRemove) break;
            mailInventory.a(i, null);
            break;
        }
        if (product != null) {
            return new ur[]{product};
        }
        return new ur[0];
    }

    @Override
    public boolean hasMail() {
        la mailInventory = this.getOrCreateMailInventory();
        for (int i = 0; i < mailInventory.k_(); ++i) {
            if (mailInventory.a(i) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(PluginForestryMail.triggerHasMail);
        return res;
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(any tile) {
            return new MachineMailbox((TileMachine)tile);
        }
    }
}

