/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import buildcraft.api.fuels.IronEngineCoolant;
import buildcraft.api.fuels.IronEngineFuel;
import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.ITriggerProvider;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.recipes.RefineryRecipe;
import buildcraft.api.transport.IPipe;
import cpw.mods.fml.common.network.IGuiHandler;
import forestry.api.core.GlobalManager;
import forestry.api.core.IOreDictionaryHandler;
import forestry.api.core.IPacketHandler;
import forestry.api.core.IPickupHandler;
import forestry.api.core.IPlugin;
import forestry.api.core.IResupplyHandler;
import forestry.api.core.ISaveEventHandler;
import forestry.api.core.PluginInfo;
import forestry.core.config.Config;
import forestry.core.config.Configuration;
import forestry.core.config.ForestryItem;
import forestry.core.config.Property;
import forestry.core.gadgets.TileForestry;
import forestry.core.proxy.Proxies;
import forestry.core.utils.EnergyConfiguration;
import forestry.core.utils.LiquidHelper;
import java.util.LinkedList;
import java.util.Random;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidStack;

@PluginInfo(pluginID="BC3", name="BuildCraft 3", author="SirSengir", url="http://forestry.sengir.net/", description="Compatibility plugin for BuildCraft 3.")
public class PluginBuildCraft
implements IPlugin,
ITriggerProvider {
    public static PluginBuildCraft instance;
    public static Configuration config;
    public static boolean ignore;
    public static int engineId;
    public static int pipeId;
    public static up wrench;
    public static up stoneGear;
    public static up pipeWaterproof;
    public static amq oilStill;
    public static amq oilMoving;
    public static up fuel;

    public PluginBuildCraft() {
        if (instance == null) {
            instance = this;
        }
    }

    @Override
    public boolean isAvailable() {
        return Proxies.common.isModLoaded("BuildCraft|Core") && Proxies.common.isModLoaded("BuildCraft|Transport");
    }

    @Override
    public void doInit() {
        config = Config.config;
        Property buildcraftignore = config.get("buildcraft.ignore", "common", false);
        buildcraftignore.Comment = "set to true to ignore buildcraft";
        ignore = Boolean.parseBoolean(buildcraftignore.Value);
        Property buildcraftengine = config.get("buildcraft.blockid.engine", "common", 161);
        buildcraftengine.Comment = "necessary to have the arboretum not clear buildcraft engines.";
        engineId = Integer.parseInt(buildcraftengine.Value);
        Property buildcraftpipe = config.get("buildcraft.blockid.pipe", "common", 166);
        buildcraftpipe.Comment = "necessary to have the arboretum not clear buildcraft pipes.";
        pipeId = Integer.parseInt(buildcraftpipe.Value);
        GlobalManager.holyBlockIds.add(engineId);
        GlobalManager.holyBlockIds.add(pipeId);
        IronEngineCoolant.coolants.add(new IronEngineCoolant(new LiquidStack(ForestryItem.liquidIce, 1), 10.0f));
        this.addIronEngineFuel(new LiquidStack(ForestryItem.liquidBiofuel, 1), 5, 40000);
        this.addRefineryRecipe(new LiquidStack(ForestryItem.liquidBiomass, 4), null, new LiquidStack(ForestryItem.liquidBiofuel, 1), 10, 1);
        ActionManager.registerTriggerProvider(this);
        this.initStoneGear();
        this.initWaterproof();
        this.initLiquids();
    }

    @Override
    public void postInit() {
    }

    private void initLiquids() {
        try {
            oilStill = (amq)Class.forName("buildcraft.BuildCraftEnergy").getField("oilStill").get(null);
            oilMoving = (amq)Class.forName("buildcraft.BuildCraftEnergy").getField("oilMoving").get(null);
            fuel = (up)Class.forName("buildcraft.BuildCraftEnergy").getField("fuel").get(null);
        }
        catch (Exception ex) {
            Proxies.log.fine("Oil or fuel not found.");
            return;
        }
        LiquidHelper.injectWaxContainer(new LiquidContainerData(new LiquidStack(oilStill, 1000), new ur(ForestryItem.waxCapsuleOil), new ur(ForestryItem.waxCapsule)));
        LiquidHelper.injectWaxContainer(new LiquidContainerData(new LiquidStack(fuel, 1000), new ur(ForestryItem.waxCapsuleFuel), new ur(ForestryItem.waxCapsule)));
        LiquidHelper.injectRefractoryContainer(new LiquidContainerData(new LiquidStack(oilStill, 1000), new ur(ForestryItem.refractoryOil), new ur(ForestryItem.refractoryEmpty)));
        LiquidHelper.injectRefractoryContainer(new LiquidContainerData(new LiquidStack(fuel, 1000), new ur(ForestryItem.refractoryFuel), new ur(ForestryItem.refractoryEmpty)));
        LiquidHelper.injectTinContainer(new LiquidContainerData(new LiquidStack(oilStill, 1000), new ur(ForestryItem.canOil), new ur(ForestryItem.canEmpty)));
        LiquidHelper.injectTinContainer(new LiquidContainerData(new LiquidStack(fuel, 1000), new ur(ForestryItem.canFuel), new ur(ForestryItem.canEmpty)));
    }

    private void addIronEngineFuel(LiquidStack fuel, int powerPerCycle, int totalBurningTime) {
        IronEngineFuel.fuels.add(new IronEngineFuel(fuel, (float)powerPerCycle, totalBurningTime));
    }

    private void addRefineryRecipe(LiquidStack ingredient1, LiquidStack ingredient2, LiquidStack result, int energy, int delay) {
        RefineryRecipe.registerRefineryRecipe(new RefineryRecipe(ingredient1, ingredient2, result, energy, delay));
    }

    private void initStoneGear() {
        try {
            stoneGear = (up)Class.forName("buildcraft.BuildCraftCore").getField("stoneGearItem").get(null);
        }
        catch (Exception ex) {
            Proxies.log.fine("No BuildCraft stone gear found.");
            return;
        }
    }

    private void initWaterproof() {
        try {
            pipeWaterproof = (up)Class.forName("buildcraft.BuildCraftTransport").getField("pipeWaterproof").get(null);
        }
        catch (Exception ex) {
            Proxies.log.fine("No BuildCraft pipe waterproof found.");
            return;
        }
        Proxies.common.addRecipe(new ur(pipeWaterproof), new Object[]{"#", Character.valueOf('#'), ForestryItem.beeswax});
    }

    public void configurePowerProvider(IPowerProvider powerProvider, EnergyConfiguration energyConfig) {
        powerProvider.configure(energyConfig.latency, energyConfig.minEnergyReceived, energyConfig.maxEnergyReceived, energyConfig.minActivationEnergy, energyConfig.maxEnergy);
        powerProvider.configurePowerPerdition(energyConfig.powerLoss, energyConfig.powerLossRegularity);
    }

    public float invokeUseEnergyMethod(IPowerProvider powerProvider, float min, float max, boolean doUse) {
        return powerProvider.useEnergy(min, max, doUse);
    }

    public void invokeReceiveEnergyMethod(IPowerProvider powerProvider, float quantity) {
        powerProvider.receiveEnergy(quantity, ForgeDirection.WEST);
    }

    @Override
    public LinkedList getPipeTriggers(IPipe pipe) {
        return null;
    }

    @Override
    public LinkedList getNeighborTriggers(amq block, any tile) {
        if (tile instanceof TileForestry) {
            return ((TileForestry)tile).getCustomTriggers();
        }
        return null;
    }

    @Override
    public String getDescription() {
        return "BuildCraft3";
    }

    @Override
    public void preInit() {
    }

    @Override
    public void generateSurface(yc world, Random rand, int chunkX, int chunkZ) {
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return null;
    }

    @Override
    public IPacketHandler getPacketHandler() {
        return null;
    }

    @Override
    public IPickupHandler getPickupHandler() {
        return null;
    }

    @Override
    public IResupplyHandler getResupplyHandler() {
        return null;
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return null;
    }

    @Override
    public IOreDictionaryHandler getDictionaryHandler() {
        return null;
    }

    @Override
    public y[] getConsoleCommands() {
        return null;
    }
}

