/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage.items;

import forestry.api.core.ForestryAPI;
import forestry.api.storage.BackpackStowEvent;
import forestry.api.storage.IBackpackDefinition;
import forestry.apiculture.gadgets.MachineApiaristChest;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.TileMachine;
import forestry.core.items.ItemInventoried;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ItemInventory;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Utils;
import forestry.storage.BackpackMode;
import java.util.Collection;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class ItemBackpack
extends ItemInventoried {
    IBackpackDefinition info;
    byte type;

    public ItemBackpack(int i, IBackpackDefinition info, int type) {
        super(i);
        this.info = info;
        this.type = (byte)type;
        this.d(1);
    }

    public IBackpackDefinition getDefinition() {
        return this.info;
    }

    public boolean q() {
        return true;
    }

    public ur a(ur itemstack, yc world, qx player) {
        if (!Proxies.common.isSimulating(world)) {
            return itemstack;
        }
        if (!player.ah()) {
            this.openGui(player, itemstack);
        } else {
            this.switchMode(itemstack);
        }
        return itemstack;
    }

    public boolean a(ur itemstack, qx player, yc world, int x2, int y2, int z2, int side, float hitX, float hitY, float hitZ) {
        return this.getInventoryHit(itemstack, player, world, x2, y2, z2) != null;
    }

    public boolean onItemUseFirst(ur itemstack, qx player, yc world, int x2, int y2, int z2, int side, float hitX, float hitY, float hitZ) {
        if (!Proxies.common.isSimulating(world)) {
            return false;
        }
        if (!player.ah()) {
            return false;
        }
        return this.evaluateTileHit(itemstack, player, world, x2, y2, z2, side, hitX, hitY, hitZ);
    }

    public ur tryStowing(qx player, ur backpackStack, ur itemstack) {
        ItemBackpack backpack = (ItemBackpack)backpackStack.b();
        ItemInventory inventory = new ItemInventory(ItemBackpack.class, backpack.getBackpackSize(), backpackStack);
        if (backpackStack.j() == 1) {
            return itemstack;
        }
        BackpackStowEvent event = new BackpackStowEvent(player, backpack.getDefinition(), inventory, itemstack);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (itemstack.a <= 0) {
            return null;
        }
        if (event.isCanceled()) {
            return itemstack;
        }
        int freeSlots = 0;
        int slot = -1;
        for (int i = 0; i < inventory.k_(); ++i) {
            int space;
            ur slotStack = inventory.a(i);
            if (slotStack == null) {
                ++freeSlots;
                if (slot >= 0) continue;
                slot = i;
                continue;
            }
            if (!slotStack.a(itemstack) || !ur.a((ur)slotStack, (ur)itemstack) || (space = slotStack.d() - slotStack.a) <= 0) continue;
            if (space < itemstack.a) {
                slotStack.a = slotStack.d();
                itemstack.a -= space;
                continue;
            }
            slotStack.a += itemstack.a;
            itemstack.a = 0;
            inventory.save();
            return null;
        }
        if (freeSlots <= 0) {
            inventory.save();
            return itemstack;
        }
        inventory.a(slot, itemstack.l());
        itemstack.a = 0;
        inventory.save();
        return null;
    }

    private void switchMode(ur itemstack) {
        BackpackMode mode = ItemBackpack.getMode(itemstack);
        if (mode == BackpackMode.RESUPPLY) {
            itemstack.b(0);
        } else if (mode == BackpackMode.RECEIVE) {
            itemstack.b(3);
        } else if (mode == BackpackMode.LOCKED) {
            itemstack.b(2);
        } else {
            itemstack.b(1);
        }
    }

    private aoh getPlayerTarget(qx player) {
        double distance = player.cd.d ? 5.0 : 4.5;
        aoj posVec = aoj.a((double)player.t, (double)player.u, (double)player.v);
        aoj lookVec = player.i(1.0f);
        posVec.d += (double)player.e();
        lookVec = posVec.c(lookVec.c * distance, lookVec.d * distance, lookVec.e * distance);
        return player.p.a(posVec, lookVec);
    }

    private la getInventoryHit(ur itemstack, qx player, yc world, int x2, int y2, int z2) {
        la inventory = null;
        aoh movingobjectposition = this.getPlayerTarget(player);
        if (movingobjectposition != null && movingobjectposition.a == aoi.a) {
            la test;
            int i = movingobjectposition.b;
            int j = movingobjectposition.c;
            int k = movingobjectposition.d;
            any targeted = world.q(i, j, k);
            if (targeted instanceof anm) {
                inventory = Utils.getChest((la)targeted);
            } else if (targeted instanceof TileMachine) {
                TileMachine machine = (TileMachine)targeted;
                if (machine.machine instanceof MachineApiaristChest && ((ItemBackpack)ForestryItem.apiaristBackpack).isBackpack(itemstack)) {
                    inventory = (la)targeted;
                }
            } else if (targeted instanceof la && (test = (la)targeted).k_() > 26) {
                inventory = test;
            }
        }
        return inventory;
    }

    private boolean evaluateTileHit(ur itemstack, qx player, yc world, int x2, int y2, int z2, int side, float hitX, float hitY, float hitZ) {
        la inventory = this.getInventoryHit(itemstack, player, world, x2, y2, z2);
        if (inventory != null) {
            if (inventory.k_() <= 0) {
                return true;
            }
            ItemInventory backpackInventory = new ItemInventory(ItemBackpack.class, this.getBackpackSize(), itemstack);
            if (itemstack.j() == 2) {
                this.tryChestReceive(player, backpackInventory, inventory);
            } else {
                this.tryChestTransfer(backpackInventory, inventory);
            }
            backpackInventory.save();
            return true;
        }
        return false;
    }

    private void tryChestTransfer(ItemInventory backpackInventory, la inventory) {
        block0: for (int l = 0; l < backpackInventory.k_(); ++l) {
            ur packstack = backpackInventory.a(l);
            if (packstack == null) continue;
            for (int m = 0; m < inventory.k_(); ++m) {
                int space;
                ur targetstack = inventory.a(m);
                if (targetstack == null) {
                    inventory.a(m, packstack.l());
                    backpackInventory.a(l, null);
                    continue block0;
                }
                if (!targetstack.a(packstack) || !ur.a((ur)targetstack, (ur)packstack) || (space = targetstack.d() - targetstack.a) <= 0) continue;
                if (space >= packstack.a) {
                    targetstack.a += packstack.a;
                    backpackInventory.a(l, packstack.a);
                    continue block0;
                }
                targetstack.a = targetstack.d();
                backpackInventory.a(l, space);
            }
        }
    }

    private void tryChestReceive(qx player, ItemInventory backpackInventory, la inventory) {
        block0: for (int i = 0; i < inventory.k_(); ++i) {
            ur inventoryStack = inventory.a(i);
            if (inventoryStack == null || !this.info.isValidItem(player, inventoryStack)) continue;
            for (int j = 0; j < backpackInventory.k_(); ++j) {
                int space;
                ur backpackStack = backpackInventory.a(j);
                if (backpackStack == null) {
                    backpackInventory.a(j, inventoryStack.l());
                    inventory.a(i, null);
                    continue block0;
                }
                if (!backpackStack.a(inventoryStack) || !ur.a((ur)inventoryStack, (ur)backpackStack) || (space = backpackStack.d() - backpackStack.a) <= 0) continue;
                if (space >= inventoryStack.a) {
                    backpackStack.a += inventoryStack.a;
                    inventory.a(i, inventoryStack.a);
                    continue block0;
                }
                backpackStack.a = backpackStack.d();
                inventory.a(i, space);
            }
        }
    }

    public void openGui(qx entityplayer, ur itemstack) {
        if (this.getBackpackSize() == 15) {
            entityplayer.openGui(ForestryAPI.instance, GuiId.BackpackGUI.ordinal(), entityplayer.p, (int)entityplayer.t, (int)entityplayer.u, (int)entityplayer.v);
        } else if (this.getBackpackSize() == 45) {
            entityplayer.openGui(ForestryAPI.instance, GuiId.BackpackT2GUI.ordinal(), entityplayer.p, (int)entityplayer.t, (int)entityplayer.u, (int)entityplayer.v);
        }
    }

    public boolean isBackpack(ur stack) {
        if (stack == null) {
            return false;
        }
        return stack.c == this.cj;
    }

    public Collection getValidItems(qx player) {
        return this.info.getValidItems(player);
    }

    public int getBackpackSize() {
        return ItemBackpack.getSlotsForType(this.type);
    }

    public void a(ur itemstack, qx player, List list, boolean flag) {
        ItemInventory inventory = new ItemInventory(ItemBackpack.class, this.getBackpackSize(), itemstack);
        int occupied = 0;
        for (int i = 0; i < inventory.k_(); ++i) {
            if (inventory.a(i) == null || inventory.a((int)i).a <= 0) continue;
            ++occupied;
        }
        BackpackMode mode = ItemBackpack.getMode(itemstack);
        if (mode == BackpackMode.LOCKED) {
            list.add("(LOCKED)");
        } else if (mode == BackpackMode.RECEIVE) {
            list.add("(RECEIVING)");
        } else if (mode == BackpackMode.RESUPPLY) {
            list.add("(RESUPPLY)");
        }
        list.add(occupied + "/" + this.getBackpackSize() + " " + StringUtil.localize("gui.slots"));
    }

    public boolean b() {
        return true;
    }

    @Override
    public String l(ur itemstack) {
        if (this.type > 1) {
            return StringUtil.localize("storage.backpack.t2adj") + " " + this.info.getName();
        }
        return this.info.getName();
    }

    public int a(ur itemstack, int j) {
        if (j == 0) {
            return this.info.getPrimaryColour();
        }
        return this.info.getSecondaryColour();
    }

    public int a(int i, int j) {
        int iconIndex = 0;
        iconIndex = j == 0 ? 112 : 113 + this.type;
        if (i > 2) {
            return iconIndex + 48;
        }
        if (i > 1) {
            return iconIndex + 32;
        }
        if (i > 0) {
            return iconIndex + 16;
        }
        return iconIndex;
    }

    public static int getSlotsForType(int type) {
        switch (type) {
            case 0: {
                return 125;
            }
            case 2: {
                return 45;
            }
        }
        return 15;
    }

    public static BackpackMode getMode(ur backpack) {
        int meta = backpack.j();
        if (meta >= 3) {
            return BackpackMode.RESUPPLY;
        }
        if (meta >= 2) {
            return BackpackMode.RECEIVE;
        }
        if (meta >= 1) {
            return BackpackMode.LOCKED;
        }
        return BackpackMode.NORMAL;
    }
}

