/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.asm;

import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import dan200.turtle.api.TurtleSide;
import java.util.ArrayList;
import miscperipherals.api.IBlastResistantPeripheral;
import miscperipherals.api.IBreakPeripheral;
import miscperipherals.api.ILightPeripheral;
import miscperipherals.api.ITankPeripheral;
import miscperipherals.util.Util;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidStack;

public class ASMHelper {
    public static int getTurtleBlockLightValue(ym world, int x, int y, int z) {
        int light = 0;
        any te = world.q(x, y, z);
        if (te instanceof ITurtleAccess) {
            ITurtleAccess turtle = (ITurtleAccess)te;
            for (TurtleSide side : Util.TURTLE_SIDES) {
                IHostedPeripheral peripheral = turtle.getPeripheral(side);
                if (!(peripheral instanceof ILightPeripheral)) continue;
                light = Math.max(light, ((ILightPeripheral)peripheral).getLightLevel());
            }
        }
        return light;
    }

    public static int fillTurtleTank(ITurtleAccess turtle, ForgeDirection from, LiquidStack resource, boolean doFill) {
        ILiquidTank tank = ASMHelper.getTurtleTank(turtle, from, resource);
        if (tank == null) {
            return 0;
        }
        return tank.fill(resource, doFill);
    }

    public static int fillTurtleTank(ITurtleAccess turtle, int tankIndex, LiquidStack resource, boolean doFill) {
        ILiquidTank[] tanks = ASMHelper.getTurtleTanks(turtle, ForgeDirection.UNKNOWN);
        if (tankIndex >= 0 && tankIndex < tanks.length) {
            return tanks[tankIndex].fill(resource, doFill);
        }
        return 0;
    }

    public static LiquidStack drainTurtleTank(ITurtleAccess turtle, ForgeDirection from, int maxDrain, boolean doDrain) {
        ILiquidTank tank = ASMHelper.getTurtleTank(turtle, from, null);
        if (tank == null) {
            return null;
        }
        return tank.drain(maxDrain, doDrain);
    }

    public static LiquidStack drainTurtleTank(ITurtleAccess turtle, int tankIndex, int maxDrain, boolean doDrain) {
        ILiquidTank[] tanks = ASMHelper.getTurtleTanks(turtle, ForgeDirection.UNKNOWN);
        if (tankIndex >= 0 && tankIndex < tanks.length) {
            return tanks[tankIndex].drain(maxDrain, doDrain);
        }
        return null;
    }

    public static ILiquidTank[] getTurtleTanks(ITurtleAccess turtle, ForgeDirection direction) {
        ArrayList<ITankPeripheral> tanks = new ArrayList<ITankPeripheral>(Util.TURTLE_SIDES.length);
        for (TurtleSide side : Util.TURTLE_SIDES) {
            ITankPeripheral tank;
            IHostedPeripheral peripheral = turtle.getPeripheral(side);
            if (!(peripheral instanceof ITankPeripheral) || !(tank = (ITankPeripheral)peripheral).canUseFromSide(direction)) continue;
            tanks.add((ITankPeripheral)peripheral);
        }
        return tanks.toArray(new ILiquidTank[0]);
    }

    public static ILiquidTank getTurtleTank(ITurtleAccess turtle, ForgeDirection direction, LiquidStack type) {
        for (ILiquidTank tank : ASMHelper.getTurtleTanks(turtle, direction)) {
            if (type != null && tank.getLiquid() != null && !tank.getLiquid().isLiquidEqual(type)) continue;
            return tank;
        }
        return null;
    }

    public static float getTurtleBlockExplosionResistance(lq exploder, yc world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        any te;
        float resistance = 0.0f;
        amq block = amq.p[world.a(x, y, z)];
        if (block != null) {
            resistance = block.a(exploder);
        }
        if ((te = world.q(x, y, z)) instanceof ITurtleAccess) {
            ITurtleAccess turtle = (ITurtleAccess)te;
            for (TurtleSide side : Util.TURTLE_SIDES) {
                IHostedPeripheral peripheral = turtle.getPeripheral(side);
                if (!(peripheral instanceof IBlastResistantPeripheral)) continue;
                resistance = Math.max(resistance, ((IBlastResistantPeripheral)peripheral).getBlastResistance(exploder, world, explosionX, explosionY, explosionZ));
            }
        }
        return resistance;
    }

    public static ArrayList getTurtleBlockDropped(ArrayList parent, yc world, int x, int y, int z, int metadata, int fortune) {
        any te;
        if (parent == null) {
            parent = new ArrayList();
        }
        if ((te = world.q(x, y, z)) instanceof ITurtleAccess) {
            ITurtleAccess turtle = (ITurtleAccess)te;
            for (TurtleSide side : Util.TURTLE_SIDES) {
                IHostedPeripheral peripheral = turtle.getPeripheral(side);
                if (!(peripheral instanceof IBreakPeripheral)) continue;
                ((IBreakPeripheral)peripheral).onBreak(turtle, fortune, parent);
            }
        }
        return parent;
    }
}

