/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.asm;

import cpw.mods.fml.relauncher.FMLRelauncher;
import cpw.mods.fml.relauncher.IClassTransformer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import miscperipherals.asm.BlockTurtleTransformer;
import miscperipherals.asm.ComputerCraftTransformer;
import miscperipherals.asm.ITransformer;
import miscperipherals.asm.MiscPeripheralsPlugin;
import miscperipherals.asm.TickHandlerClientTransformer;
import miscperipherals.asm.TileEntityTurtleRendererTransformer;
import miscperipherals.asm.TileEntityTurtleTransformer;
import miscperipherals.safe.SafeModeManager;

public class ClassTransformer
implements IClassTransformer {
    private final Map transformers = new HashMap();

    public ClassTransformer() {
        this.addTransformer("dan200.ComputerCraft", new ComputerCraftTransformer());
        this.addTransformer("dan200.turtle.shared.BlockTurtle", new BlockTurtleTransformer());
        this.addTransformer("dan200.turtle.shared.TileEntityTurtle", new TileEntityTurtleTransformer());
        if (FMLRelauncher.side().equalsIgnoreCase("client")) {
            this.addTransformer("dan200.turtle.client.TileEntityTurtleRenderer", new TileEntityTurtleRendererTransformer());
            this.addTransformer("portalgun.client.core.TickHandlerClient", new TickHandlerClientTransformer());
        }
    }

    public byte[] transform(String name, byte[] bytes) {
        if (SafeModeManager.SAFE_MODE) {
            return bytes;
        }
        String cname = name.toLowerCase().replaceAll("/", ".");
        if (this.transformers.containsKey(cname)) {
            MiscPeripheralsPlugin.log.log(Level.INFO, "Transforming class " + name);
            return ((ITransformer)this.transformers.get(cname)).transform(bytes);
        }
        return bytes;
    }

    private void addTransformer(String name, ITransformer transformer) {
        this.transformers.put(name.toLowerCase(), transformer);
    }
}

