/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.core;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;

public class TickHandler
implements ITickHandler {
    private static Map callbacks = Collections.synchronizedMap(new HashMap());

    public void tickStart(EnumSet type, Object ... tickData) {
        if (type.contains(TickType.WORLD)) {
            yc world = (yc)tickData[0];
            if (callbacks.containsKey(world.u.h)) {
                Queue callbackList = (Queue)callbacks.get(world.u.h);
                FutureTask callback = (FutureTask)callbackList.poll();
                while (callback != null) {
                    callback.run();
                    callback = (FutureTask)callbackList.poll();
                }
            }
        }
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
    }

    public EnumSet ticks() {
        return EnumSet.of(TickType.WORLD);
    }

    public String getLabel() {
        return "MiscPeripherals";
    }

    public static Future addTickCallback(yc world, Callable callback) throws InterruptedException {
        if (!callbacks.containsKey(world.u.h)) {
            callbacks.put(world.u.h, new LinkedBlockingQueue());
        }
        FutureTask task = new FutureTask(callback);
        ((LinkedBlockingQueue)callbacks.get(world.u.h)).put(task);
        return task;
    }
}

