/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.external;

import dan200.computer.api.IComputerAccess;
import miscperipherals.external.ExtTrack;
import miscperipherals.safe.Reflector;
import railcraft.common.api.tracks.ITrackInstance;

public abstract class ExtTrackNumber
extends ExtTrack {
    private final String field;
    private final Class fieldType;
    private final int min;
    private final int max;

    public ExtTrackNumber(ITrackInstance track, String field, Class fieldType, int min, int max) {
        super(track);
        this.field = field;
        this.fieldType = fieldType;
        this.min = min;
        this.max = max;
    }

    @Override
    public abstract String getType();

    @Override
    public String[] getMethodNames() {
        return new String[]{"get", "set"};
    }

    @Override
    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                if (arguments.length < 1) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                int num = (int)Math.floor((Double)arguments[0]);
                if (num < this.min || num > this.max) {
                    throw new Exception("invalid value " + num + " (expected " + this.min + "-" + this.max + ")");
                }
                Reflector.setField(this.track, this.field, Reflector.construct(this.fieldType.getName(), this.fieldType, Integer.toString(num)));
                return this.callMethod(computer, 1, arguments);
            }
            case 1: {
                return new Object[]{Reflector.getField(this.track, this.field, this.fieldType)};
            }
        }
        return null;
    }
}

