/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.module;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.Loader;
import dan200.turtle.api.ITurtleAccess;
import dan200.turtle.api.ITurtleUpgrade;
import dan200.turtle.api.TurtleAPI;
import ic2.api.ElectricItem;
import ic2.api.IC2Reactor;
import ic2.api.IElectricItem;
import ic2.api.IWrenchable;
import ic2.api.Ic2Recipes;
import ic2.api.Items;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyTile;
import java.util.ArrayList;
import miscperipherals.api.IRTGFuel;
import miscperipherals.api.IWrench;
import miscperipherals.api.MiscPeripheralsAPI;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.core.Module;
import miscperipherals.peripheral.PeripheralRTG;
import miscperipherals.safe.Reflector;
import miscperipherals.tile.TileChargeStation;
import miscperipherals.upgrade.UpgradeLaser;
import miscperipherals.upgrade.UpgradeOreScanner;
import miscperipherals.upgrade.UpgradeShield;
import miscperipherals.upgrade.UpgradeSolar;
import miscperipherals.upgrade.UpgradeTreetap;
import miscperipherals.util.FakePlayer;
import miscperipherals.util.Util;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.oredict.OreDictionary;

public class ModuleIC2
extends Module {
    public static boolean enableLaser = true;
    public static boolean enableSolar = true;
    public static boolean enableTreetap = true;
    public static boolean enableODScanner = true;
    public static boolean enableOVScanner = true;
    public static boolean enableReinforcedShield = true;
    private boolean hasGT;
    private ur refinedUranium = Items.getItem((String)"refinedUranium");
    private ur uraniumBlock = Items.getItem((String)"uraniumBlock");
    private ur reactorUraniumSimple = Items.getItem((String)"reactorUraniumSimple");
    private ur reactorUraniumDual = Items.getItem((String)"reactorUraniumDual");
    private ur reactorUraniumQuad = Items.getItem((String)"reactorUraniumQuad");

    @Override
    public void onPreInit() {
        MiscPeripherals instance = MiscPeripherals.instance;
        this.hasGT = Loader.isModLoaded((String)"GregTech_Addon");
        enableLaser = instance.settings.get("features", "enableLaser", enableLaser, "Enable the Laser turtle upgrade").getBoolean(enableLaser);
        enableSolar = instance.settings.get("features", "enableSolar", enableSolar, "Enable the Solar turtle upgrade").getBoolean(enableSolar);
        enableTreetap = instance.settings.get("features", "enableTreetap", enableTreetap, "Enable the Treetap turtle upgrade").getBoolean(enableTreetap);
        enableODScanner = instance.settings.get("features", "enableODScanner", enableODScanner, "Enable the Ore Scanner turtle upgrade").getBoolean(enableODScanner);
        enableOVScanner = instance.settings.get("features", "enableOVScanner", enableOVScanner, "Enable the Advanced Ore Scanner turtle upgrade").getBoolean(enableOVScanner);
        if (MiscPeripherals.hasShields()) {
            enableReinforcedShield = MiscPeripherals.instance.settings.get("features", "enableReinforcedStoneShield", enableReinforcedShield, "Enable the Reinforced Shield turtle upgrade").getBoolean(enableReinforcedShield);
        }
    }

    @Override
    public void onInit() {
        if (MiscPeripherals.instance.enableChargeStation) {
            Ic2Recipes.addShapelessCraftingRecipe((ur)new ur((amq)MiscPeripherals.instance.blockAlpha, 1, 0), (Object[])new Object[]{this.hasGT ? "10kEUStore" : Items.getItem((String)"reBattery"), this.hasGT ? "rawMachineTier01" : Items.getItem((String)"machine"), up.aC});
        }
    }

    @Override
    public void onPostInit() {
        if (enableLaser) {
            TurtleAPI.registerUpgrade((ITurtleUpgrade)new UpgradeLaser());
        }
        if (enableSolar) {
            TurtleAPI.registerUpgrade((ITurtleUpgrade)new UpgradeSolar());
        }
        if (enableTreetap) {
            TurtleAPI.registerUpgrade((ITurtleUpgrade)new UpgradeTreetap());
        }
        if (enableODScanner) {
            TurtleAPI.registerUpgrade((ITurtleUpgrade)new UpgradeOreScanner(false));
        }
        if (enableOVScanner) {
            TurtleAPI.registerUpgrade((ITurtleUpgrade)new UpgradeOreScanner(true));
        }
        if (MiscPeripherals.hasShields() && enableReinforcedShield) {
            TurtleAPI.registerUpgrade((ITurtleUpgrade)new UpgradeShield(210, amq.p[Items.getItem((String)"reinforcedStone").c], 0));
        }
        if (MiscPeripherals.instance.enableChargeStationT2) {
            Ic2Recipes.addCraftingRecipe((ur)new ur((amq)MiscPeripherals.instance.blockBeta, 1, 1), (Object[])new Object[]{" # ", "C@C", " $ ", Character.valueOf('C'), Items.getItem((String)"doubleInsulatedGoldCableItem"), Character.valueOf('#'), this.hasGT ? "circuitTier02" : Items.getItem((String)"electronicCircuit"), Character.valueOf('$'), this.hasGT ? "100kEUStore" : Items.getItem((String)"energyCrystal"), Character.valueOf('@'), MiscPeripherals.instance.enableChargeStation ? new ur((amq)MiscPeripherals.instance.blockAlpha, 1, 0) : (this.hasGT ? "rawMachineTier01" : Items.getItem((String)"machine"))});
        }
        if (MiscPeripherals.instance.enableChargeStationT3) {
            Ic2Recipes.addCraftingRecipe((ur)new ur((amq)MiscPeripherals.instance.blockBeta, 1, 2), (Object[])new Object[]{" # ", "C@C", " $ ", Character.valueOf('C'), Items.getItem((String)"glassFiberCableItem"), Character.valueOf('#'), this.hasGT ? "circuitTier04" : Items.getItem((String)"advancedCircuit"), Character.valueOf('$'), this.hasGT ? "1kkEUStore" : Items.getItem((String)"lapotronCrystal"), Character.valueOf('@'), MiscPeripherals.instance.enableChargeStationT2 ? new ur((amq)MiscPeripherals.instance.blockBeta, 1, 1) : (MiscPeripherals.instance.enableChargeStation ? new ur((amq)MiscPeripherals.instance.blockAlpha, 1, 0) : (this.hasGT ? "rawMachineTier02" : Items.getItem((String)"advancedMachine")))});
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        IWrench.handlers.add(new IWrench(){

            @Override
            public boolean wrench(ITurtleAccess turtle, yc world, int x, int y, int z, int side) {
                FakePlayer player = FakePlayer.get(turtle);
                player.alignToTurtle(turtle);
                player.setHeldItem(this.getItem());
                any te = world.q(x, y, z);
                if (te instanceof IWrenchable) {
                    IWrenchable wrenchable = (IWrenchable)te;
                    if (wrenchable.wrenchCanSetFacing((qx)player, side)) {
                        wrenchable.setFacing((short)side);
                        return true;
                    }
                    if (wrenchable.wrenchCanRemove((qx)player)) {
                        Boolean logWrench = (Boolean)Reflector.getField("ic2.core.IC2", "enableLoggingWrench", Boolean.class);
                        if (logWrench != null && logWrench.booleanValue()) {
                            MiscPeripherals.log.info("Turtle " + turtle + " used a wrench to remove " + wrenchable + " at (" + te.l + "," + te.m + "," + te.n + ")");
                        }
                        int id = world.a(te.l, te.m, te.n);
                        int meta = world.h(te.l, te.m, te.n);
                        ArrayList drops = amq.p[id].getBlockDropped(world, te.l, te.m, te.n, meta, 0);
                        if (world.t.nextFloat() <= wrenchable.getWrenchDropRate()) {
                            if (drops.isEmpty()) {
                                drops.add(wrenchable.getWrenchDrop((qx)player));
                            } else {
                                drops.set(0, wrenchable.getWrenchDrop((qx)player));
                            }
                        }
                        for (ur drop : drops) {
                            Util.storeOrDrop(turtle, drop);
                        }
                        world.e(te.l, te.m, te.n, 0);
                        return true;
                    }
                }
                return false;
            }

            @Override
            public boolean wrench(ITurtleAccess turtle, lq entity) {
                return false;
            }

            @Override
            public ur getItem() {
                return Items.getItem((String)"wrench");
            }
        });
        IRTGFuel.handlers.add(new IRTGFuel(){

            @Override
            public int get(ur stack) {
                if (Util.areStacksEqual(stack, ModuleIC2.this.refinedUranium)) {
                    return PeripheralRTG.URANIUM_TOTAL;
                }
                if (Util.areStacksEqual(stack, ModuleIC2.this.uraniumBlock)) {
                    return PeripheralRTG.URANIUM_TOTAL * 9;
                }
                if (stack.c == ((ModuleIC2)ModuleIC2.this).reactorUraniumSimple.c) {
                    return (int)((float)PeripheralRTG.URANIUM_TOTAL * (1.0f - (float)stack.j() / (float)stack.k()));
                }
                if (stack.c == ((ModuleIC2)ModuleIC2.this).reactorUraniumDual.c) {
                    return (int)((float)PeripheralRTG.URANIUM_TOTAL * 2.0f * (1.0f - (float)stack.j() / (float)stack.k()));
                }
                if (stack.c == ((ModuleIC2)ModuleIC2.this).reactorUraniumQuad.c) {
                    return (int)((float)PeripheralRTG.URANIUM_TOTAL * 4.0f * (1.0f - (float)stack.j() / (float)stack.k()));
                }
                return 0;
            }
        });
        MiscPeripheralsAPI.instance.addFurnaceXP(Reflector.getClass("ic2.core.block.machine.tileentity.TileEntityElecFurnace"), 2);
        MiscPeripheralsAPI.instance.addFurnaceXP(Reflector.getClass("ic2.core.block.machine.tileentity.TileEntityInduction"), 3, 4);
        TileChargeStation.PLUGINS.add(new TileChargeStation.ChargeStationPlugin(){

            @Override
            public void update(TileChargeStation station) {
                IElectricItem ee;
                ur battery;
                if (!station.addedToEnergyNet) {
                    MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)station));
                    station.addedToEnergyNet = true;
                }
                if ((battery = station.a(0)) != null && battery.b() instanceof IElectricItem && (ee = (IElectricItem)battery.b()).canProvideEnergy()) {
                    station.energy += (double)ElectricItem.discharge((ur)battery, (int)((int)Math.ceil((double)station.getMaxCharge() - station.energy)), (int)station.tier, (boolean)false, (boolean)false);
                }
            }

            @Override
            public boolean isBattery(TileChargeStation station, ur item) {
                if (item.b() instanceof IElectricItem) {
                    IElectricItem iee = (IElectricItem)item.b();
                    return iee.canProvideEnergy() && iee.getTier() <= station.tier;
                }
                return false;
            }

            @Override
            public void unload(TileChargeStation station) {
                if (!station.k.I) {
                    MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)station));
                    station.addedToEnergyNet = false;
                }
            }

            @Override
            public boolean onBlockActivated(TileChargeStation station, qx player, int side, float hitX, float hitY, float hitZ) {
                return false;
            }

            @Override
            public void readFromNBT(TileChargeStation station, bq compound) {
            }

            @Override
            public void writeToNBT(TileChargeStation station, bq compound) {
            }

            @Override
            public void initialize(TileChargeStation station) {
            }
        });
        ur uranium = Items.getItem((String)"reactorUraniumSimple");
        if (uranium != null && uranium.b() != null) {
            int euOutput = IC2Reactor.getEUOutput();
            PeripheralRTG.URANIUM_TOTAL = uranium.k() * PeripheralRTG.OUTPUT * euOutput * 20;
        } else {
            MiscPeripherals.log.warning("!!! IC2 URANIUM IS NULL !!! GregTech?");
        }
        OreDictionary.registerOre((String)"MiscPeripherals$rtgChamber", (ur)Items.getItem((String)"reactorChamber"));
        OreDictionary.registerOre((String)"MiscPeripherals$rtgGenerator", (ur)Items.getItem((String)"generator"));
        OreDictionary.registerOre((String)"MiscPeripherals$rtgCircuit", (ur)Items.getItem((String)"advancedCircuit"));
    }

    @Override
    public void handleNetworkMessage(eg source, boolean isClient, ByteArrayDataInput data) {
    }
}

