/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.module;

import com.google.common.io.ByteArrayDataInput;
import dan200.turtle.api.ITurtleAccess;
import dan200.turtle.api.ITurtleUpgrade;
import dan200.turtle.api.TurtleAPI;
import miscperipherals.api.IXPSource;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.core.Module;
import miscperipherals.safe.Reflector;
import miscperipherals.upgrade.UpgradeThaumScanner;
import miscperipherals.upgrade.UpgradeWand;

public class ModuleThaumcraft
extends Module {
    public static boolean enableThaumScanner = true;
    public static boolean enableWand = true;

    @Override
    public void onPreInit() {
        enableThaumScanner = MiscPeripherals.instance.settings.get("features", "enableThaumScanner", enableThaumScanner, "Enable the Thaum Scanner turtle upgrade").getBoolean(enableThaumScanner);
        enableWand = MiscPeripherals.instance.settings.get("features", "enableWand", enableWand, "Enable the Wand turtle upgrade").getBoolean(enableWand);
    }

    @Override
    public void onInit() {
    }

    @Override
    public void onPostInit() {
        if (enableThaumScanner) {
            TurtleAPI.registerUpgrade((ITurtleUpgrade)new UpgradeThaumScanner());
        }
        if (enableWand) {
            TurtleAPI.registerUpgrade((ITurtleUpgrade)new UpgradeWand());
        }
        IXPSource.handlers.add(new IXPSource(){

            @Override
            public int get(ITurtleAccess turtle, int x, int y, int z, int side) {
                any te = turtle.getWorld().q(x, y, z);
                if (!te.getClass().getName().equals("thaumcraft.common.blocks.jars.TileJarBrain")) {
                    return 0;
                }
                Integer xp = (Integer)Reflector.getField(te, "xp", Integer.class);
                if (xp != null) {
                    Reflector.setField(te, "xp", 0);
                    return xp;
                }
                return 0;
            }
        });
    }

    @Override
    public void handleNetworkMessage(eg source, boolean isClient, ByteArrayDataInput data) {
    }
}

