/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.object;

import dan200.computer.core.ILuaObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class ObjectGeneric
implements ILuaObject {
    private List methods = new ArrayList();

    public ObjectGeneric() {
        for (Method method : this.getClass().getDeclaredMethods()) {
            if (method.getReturnType() != Object[].class || method.getParameterTypes().length != 1 || method.getParameterTypes()[0] != Object[].class) continue;
            this.methods.add(method);
        }
    }

    public String[] getMethodNames() {
        ArrayList<String> methodNames = new ArrayList<String>(this.methods.size());
        for (int i = 0; i < this.methods.size(); ++i) {
            methodNames.add(((Method)this.methods.get(i)).getName());
        }
        return methodNames.toArray(new String[0]);
    }

    public Object[] callMethod(int var1, Object[] var2) throws Exception {
        if (var1 >= 0 && var1 < this.methods.size()) {
            try {
                return (Object[])((Method)this.methods.get(var1)).invoke((Object)this, var2);
            }
            catch (InvocationTargetException e) {
                throw (Exception)e.getCause();
            }
        }
        return new Object[0];
    }

    void checkArgCount(Object[] args, int minimum) {
        if (args.length < 0 || args.length < minimum) {
            throw new IllegalArgumentException("too few arguments");
        }
    }

    double checkDouble(Object[] args, int arg, double def) {
        if (args.length <= arg) {
            return def;
        }
        if (!(args[arg] instanceof Double)) {
            throw new IllegalArgumentException("bad argument #" + (arg + 1) + " (expected number)");
        }
        return (Double)args[arg];
    }

    int checkInt(Object[] args, int arg, int def) {
        if (args.length <= arg) {
            return def;
        }
        if (!(args[arg] instanceof Double)) {
            throw new IllegalArgumentException("bad argument #" + (arg + 1) + " (expected number)");
        }
        return (int)Math.floor((Double)args[arg]);
    }

    float checkFloat(Object[] args, int arg, float def) {
        if (args.length <= arg) {
            return def;
        }
        if (!(args[arg] instanceof Double)) {
            throw new IllegalArgumentException("bad argument #" + (arg + 1) + " (expected number)");
        }
        return ((Float)args[arg]).floatValue();
    }

    boolean checkBoolean(Object[] args, int arg, boolean def) {
        if (args.length <= arg) {
            return def;
        }
        if (!(args[arg] instanceof Boolean)) {
            throw new IllegalArgumentException("bad argument #" + (arg + 1) + " (expected boolean)");
        }
        return (Boolean)args[arg];
    }

    String checkString(Object[] args, int arg, String def) {
        if (args.length <= arg) {
            return def;
        }
        if (!(args[arg] instanceof String)) {
            throw new IllegalArgumentException("bad argument #" + (arg + 1) + " (expected string)");
        }
        return (String)args[arg];
    }

    Map checkMap(Object[] args, int arg, Map def) {
        if (args.length <= arg) {
            return def;
        }
        if (!(args[arg] instanceof Map)) {
            throw new IllegalArgumentException("bad argument #" + (arg + 1) + " (expected table)");
        }
        return (Map)args[arg];
    }
}

