/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.tile.TilePeripheralWrapper;
import miscperipherals.util.Positionable;
import miscperipherals.util.Util;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class PeripheralChatBox
implements IHostedPeripheral {
    private static final int TICKER_INTERVAL = 20;
    private final Positionable positionable;
    private Map computers = new WeakHashMap();
    private int ticker = 0;
    private int subticker = 0;

    public PeripheralChatBox(ITurtleAccess turtle) {
        this.positionable = new Positionable.PositionableTurtle(turtle);
        this.init();
    }

    public PeripheralChatBox(TilePeripheralWrapper tile) {
        this.positionable = new Positionable.PositionableTile(tile);
        this.init();
    }

    public String getType() {
        return "chat";
    }

    public String[] getMethodNames() {
        return new String[]{"say"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                if (arguments.length < 1) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof String)) {
                    throw new Exception("bad argument #1 (expected string)");
                }
                if (arguments.length > 1 && !(arguments[1] instanceof Double)) {
                    throw new Exception("bad argument #2 (expected number)");
                }
                if (arguments.length > 2 && !(arguments[2] instanceof Boolean)) {
                    throw new Exception("bad argument #3 (expected boolean)");
                }
                if (++this.ticker > MiscPeripherals.instance.chatSayRate + 1) {
                    throw new Exception("too many messages (over " + MiscPeripherals.instance.chatSayRate + " per tick)");
                }
                String message = Util.sanitize((String)arguments[0], MiscPeripherals.instance.chatColorCodes);
                double range = Math.min(arguments.length > 1 ? (Double)arguments[1] : Double.MAX_VALUE, MinecraftServer.D().T() ? (MiscPeripherals.instance.chatSayRange < 0 ? Double.MAX_VALUE : (double)MiscPeripherals.instance.chatSayRange) : Double.MAX_VALUE);
                boolean unlimitedVertical = arguments.length > 2 ? ((Boolean)arguments[2]).booleanValue() && MiscPeripherals.instance.chatSayUnlimitedVertical : false;
                aoj pos = this.positionable.getPosition();
                for (qx player : this.positionable.getWorld().h) {
                    aoj playerpos = Util.getPosition((lq)player, 1.0f);
                    if (unlimitedVertical) {
                        playerpos.d = pos.d;
                    }
                    if (pos.d(playerpos) > range) continue;
                    player.a("[#" + (MiscPeripherals.instance.chatLogCoords ? ":" + (int)Math.floor(pos.c) + "," + (int)Math.floor(pos.d) + "," + (int)Math.floor(pos.e) : "") + "] " + message);
                }
                return new Object[]{true};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        this.computers.put(computer, true);
    }

    public void detach(IComputerAccess computer) {
        this.computers.remove(computer);
    }

    public void update() {
        if (++this.subticker > 20) {
            this.ticker = 0;
            this.subticker = 0;
        }
    }

    public void readFromNBT(bq nbttagcompound) {
    }

    public void writeToNBT(bq nbttagcompound) {
    }

    private void onChat(qx player, String message) {
        if (this.notInRange(player)) {
            return;
        }
        for (IComputerAccess computer : this.computers.keySet()) {
            computer.queueEvent("chat", new Object[]{player.an(), message});
        }
    }

    private void onDeath(qx player, lh source) {
        lq ent;
        if (this.notInRange(player)) {
            return;
        }
        String killer = null;
        if (source instanceof li && (ent = ((li)source).g()) != null) {
            killer = ent.an();
        }
        for (IComputerAccess computer : this.computers.keySet()) {
            computer.queueEvent("chat_death", new Object[]{player.an(), killer, source.q});
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean notInRange(qx player) {
        aoj pos = this.positionable.getPosition();
        if (pos == null) {
            MiscPeripherals.log.warning("Chat box pos is null!");
            return true;
        }
        if (MinecraftServer.D() == null) {
            MiscPeripherals.log.warning("Server is null for chat box at " + pos.c + "," + pos.d + "," + pos.e + " on " + this.positionable.getWorld() + "!");
            return true;
        }
        if (!MinecraftServer.D().T()) return false;
        double d = pos.d(Util.getPosition((lq)player, 1.0f));
        double d2 = MiscPeripherals.instance.chatReadRange < 0.0 ? Double.MAX_VALUE : MiscPeripherals.instance.chatReadRange;
        if (!(d > d2)) return false;
        return true;
    }

    private void init() {
        ChatListener.peripherals.put(this, true);
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)new ChatListener());
    }

    public static class ChatListener {
        private static Map peripherals = Collections.synchronizedMap(new WeakHashMap());

        @ForgeSubscribe
        public void onServerChat(ServerChatEvent event) {
            for (PeripheralChatBox peripheral : peripherals.keySet()) {
                peripheral.onChat((qx)event.player, event.message);
            }
        }

        @ForgeSubscribe
        public void onLivingDeath(LivingDeathEvent event) {
            if (!(event.entity instanceof iq)) {
                return;
            }
            for (PeripheralChatBox peripheral : peripherals.keySet()) {
                peripheral.onDeath((qx)((iq)event.entity), event.source);
            }
        }
    }
}

