/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.ITriggerParameter;
import buildcraft.api.gates.TriggerParameter;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import miscperipherals.core.LuaManager;
import miscperipherals.core.TickHandler;
import miscperipherals.tile.TilePeripheralWrapper;
import miscperipherals.util.Positionable;
import net.minecraftforge.common.ForgeDirection;

public class PeripheralGateReader
implements IHostedPeripheral {
    public static final TriggerParameter DUMMY_PARAM = new TriggerParameter();
    private Positionable positionable;

    public PeripheralGateReader(ITurtleAccess turtle) {
        this.positionable = new Positionable.PositionableTurtle(turtle);
    }

    public PeripheralGateReader(TilePeripheralWrapper tile) {
        this.positionable = new Positionable.PositionableTile(tile);
    }

    public String getType() {
        return "gateReader";
    }

    public String[] getMethodNames() {
        return new String[]{"get"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        TriggerParameter param = DUMMY_PARAM;
        if (arguments.length > 0) {
            if (!(arguments[0] instanceof Double)) {
                throw new Exception("bad argument #1 (expected number)");
            }
            la inv = this.positionable.getInventory();
            if (inv == null) {
                throw new Exception("only available in turtle version");
            }
            int slot = (int)Math.floor((Double)arguments[0]);
            if (slot < 1 || slot > inv.k_()) {
                throw new Exception("bad slot " + slot + " (expected 1-" + inv.k_() + ")");
            }
            ur slotstack = inv.a(slot - 1);
            if (slotstack != null) {
                ur stack = slotstack.l();
                stack.a = 1;
                param = new TriggerParameter();
                param.set(stack);
            }
        }
        final yc world = this.positionable.getWorld();
        final TriggerParameter finalParam = param;
        Future callback = TickHandler.addTickCallback(world, new Callable(){

            public Map call() {
                aoj position = PeripheralGateReader.this.positionable.getPosition();
                HashMap<String, Boolean> triggers = new HashMap<String, Boolean>();
                for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                    any te = world.q((int)position.c + direction.offsetX, (int)position.d + direction.offsetY, (int)position.e + direction.offsetZ);
                    for (ITrigger trigger : ActionManager.getNeighborTriggers((amq)amq.p[world.a((int)position.c + direction.offsetX, (int)position.d + direction.offsetY, (int)position.e + direction.offsetZ)], (any)te)) {
                        triggers.put(trigger.getDescription(), trigger.isTriggerActive(te, (ITriggerParameter)finalParam));
                    }
                }
                return triggers;
            }
        });
        return new Object[]{callback.get()};
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
    }

    public void detach(IComputerAccess computer) {
    }

    public void update() {
    }

    public void readFromNBT(bq nbttagcompound) {
    }

    public void writeToNBT(bq nbttagcompound) {
    }
}

