/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import dan200.turtle.api.TurtleSide;
import java.util.Random;
import miscperipherals.core.LuaManager;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.util.Util;
import net.minecraftforge.common.ForgeDirection;

public class PeripheralSolar
implements IHostedPeripheral {
    final ITurtleAccess turtle;
    private final TurtleSide side;
    private int euBuffer = 0;
    private int ticker = new Random().nextInt(20);
    boolean sunVisible = false;
    boolean skyVisible = false;

    public PeripheralSolar(ITurtleAccess turtle, TurtleSide side) {
        this.turtle = turtle;
        this.side = side;
    }

    public String getType() {
        return "solar";
    }

    public String[] getMethodNames() {
        return new String[]{"getProduction"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.getProduction()};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
    }

    public void detach(IComputerAccess computer) {
    }

    public void update() {
        if (!MiscPeripherals.proxy.isServer()) {
            return;
        }
        aoj pos = this.turtle.getPosition();
        if (pos != null && ++this.ticker >= 20) {
            this.ticker = 0;
            yc world = this.turtle.getWorld();
            if (world != null) {
                int x = (int)Math.floor(pos.c);
                int y = (int)Math.floor(pos.d);
                int z = (int)Math.floor(pos.e);
                if (MiscPeripherals.instance.sideSensitive) {
                    ForgeDirection dir = Util.getDirectionFromTurtleSide(this.side, this.turtle.getFacingDir());
                    x += dir.offsetX;
                    y += dir.offsetY;
                    z += dir.offsetZ;
                }
                this.skyVisible = !world.u.f && world.k(x, y, z);
                boolean bl = this.sunVisible = world.u() && this.skyVisible && (world.t().a(x, z) instanceof ze || !world.N() && !world.M());
            }
        }
        if (this.canUpdate()) {
            this.euBuffer += this.getProduction();
            while (this.euBuffer >= MiscPeripherals.instance.fuelEU) {
                this.euBuffer -= MiscPeripherals.instance.fuelEU * Util.addFuel(this.turtle, 1);
            }
        }
    }

    boolean canUpdate() {
        return this.sunVisible;
    }

    int getProduction() {
        return 1;
    }

    public void readFromNBT(bq nbttagcompound) {
    }

    public void writeToNBT(bq nbttagcompound) {
    }
}

