/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.network.PacketDispatcher;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import miscperipherals.api.ILightPeripheral;
import miscperipherals.api.ITankPeripheral;
import miscperipherals.core.LuaManager;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.core.TickHandler;
import miscperipherals.util.Util;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;

public class PeripheralTank
implements IHostedPeripheral,
ILightPeripheral,
ITankPeripheral {
    public static final int CAPACITY = 10000;
    public static final int TICK_RATE = 20;
    private final ITurtleAccess turtle;
    public LiquidStack liquid;
    private LiquidStack prevLiquid;
    private int prevGauge = 0;
    private int ticker = new Random().nextInt();

    public PeripheralTank(ITurtleAccess turtle) {
        this.turtle = turtle;
    }

    public String getType() {
        return "tank";
    }

    public String[] getMethodNames() {
        return new String[]{"suck", "suckUp", "suckDown", "drop", "dropUp", "dropDown", "getLiquid", "pack", "unpack"};
    }

    public Object[] callMethod(IComputerAccess computer, final int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: 
            case 1: 
            case 2: {
                int amount = Integer.MAX_VALUE;
                if (arguments.length > 0) {
                    if (!(arguments[0] instanceof Double)) {
                        throw new Exception("bad argument #1 (expected number)");
                    }
                    amount = (int)Math.floor((Double)arguments[0]);
                }
                final int doAmount = amount;
                Future callback = TickHandler.addTickCallback(this.turtle.getWorld(), new Callable(){

                    public Object call() {
                        int adding;
                        yc world = PeripheralTank.this.turtle.getWorld();
                        aoh mop = Util.rayTraceBlock(PeripheralTank.this.turtle, method == 0 ? PeripheralTank.this.turtle.getFacingDir() : (method == 1 ? 1 : 0));
                        any te = world.q(mop.b, mop.c, mop.d);
                        if (!(te instanceof ITankContainer)) {
                            if (PeripheralTank.this.liquid != null && 10000 - PeripheralTank.this.liquid.amount < 1000) {
                                return null;
                            }
                            int block = world.a(mop.b, mop.c, mop.d);
                            if (amq.p[block] == null || amq.p[block].isAirBlock(world, mop.b, mop.c, mop.d)) {
                                return null;
                            }
                            int meta = world.h(mop.b, mop.c, mop.d);
                            if (PeripheralTank.this.liquid != null && (PeripheralTank.this.liquid.itemID != block || PeripheralTank.this.liquid.itemMeta != meta)) {
                                return 0;
                            }
                            for (LiquidContainerData data : LiquidContainerRegistry.getRegisteredLiquidContainerData()) {
                                if (data.stillLiquid.itemID != block || data.stillLiquid.itemMeta != meta) continue;
                                world.e(mop.b, mop.c, mop.d, 0);
                                world.i(mop.b, mop.c, mop.d);
                                if (PeripheralTank.this.liquid == null) {
                                    PeripheralTank.this.liquid = new LiquidStack(block, 1000, meta);
                                } else {
                                    PeripheralTank.this.liquid.amount += 1000;
                                }
                                return 1000;
                            }
                            return null;
                        }
                        ITankContainer container = (ITankContainer)te;
                        ForgeDirection side = ForgeDirection.getOrientation((int)mop.e);
                        LiquidStack added = container.drain(side, adding = Math.min(doAmount, 10000 - (PeripheralTank.this.liquid == null ? 0 : PeripheralTank.this.liquid.amount)), false);
                        if (added == null || PeripheralTank.this.liquid != null && (added.itemID != PeripheralTank.this.liquid.itemID || added.itemMeta != PeripheralTank.this.liquid.itemMeta)) {
                            return 0;
                        }
                        added = container.drain(side, adding, true);
                        if (PeripheralTank.this.liquid == null) {
                            PeripheralTank.this.liquid = added;
                        } else {
                            PeripheralTank.this.liquid.amount += added.amount;
                        }
                        PeripheralTank.this.updateLiquid();
                        return added.amount;
                    }
                });
                return new Object[]{callback.get()};
            }
            case 3: 
            case 4: 
            case 5: {
                int amount = Integer.MAX_VALUE;
                if (arguments.length > 0) {
                    if (!(arguments[0] instanceof Double)) {
                        throw new Exception("bad argument #1 (expected number)");
                    }
                    amount = (int)Math.floor((Double)arguments[0]);
                }
                final int doAmount = amount;
                if (this.liquid == null) {
                    return new Object[]{0};
                }
                Future callback = TickHandler.addTickCallback(this.turtle.getWorld(), new Callable(){

                    public Object call() {
                        yc world = PeripheralTank.this.turtle.getWorld();
                        aoh mop = Util.rayTraceBlock(PeripheralTank.this.turtle, method == 3 ? PeripheralTank.this.turtle.getFacingDir() : (method == 4 ? 1 : 0));
                        any te = world.q(mop.b, mop.c, mop.d);
                        if (!(te instanceof ITankContainer)) {
                            if (PeripheralTank.this.liquid.itemID >= amq.p.length || amq.p[PeripheralTank.this.liquid.itemID] == null || amq.p[PeripheralTank.this.liquid.itemID].isAirBlock(world, mop.b, mop.c, mop.d)) {
                                return new Object[]{null};
                            }
                            if (PeripheralTank.this.liquid.amount < 1000) {
                                return new Object[]{0};
                            }
                            int block = world.a(mop.b, mop.c, mop.d);
                            if (amq.p[block] != null && amq.p[block].isAirBlock(world, mop.b, mop.c, mop.d)) {
                                return new Object[]{null};
                            }
                            world.d(mop.b, mop.c, mop.d, PeripheralTank.this.liquid.itemID, PeripheralTank.this.liquid.itemMeta);
                            world.i(mop.b, mop.c, mop.d);
                            PeripheralTank.this.liquid.amount -= 1000;
                            if (PeripheralTank.this.liquid.amount <= 0) {
                                PeripheralTank.this.liquid = null;
                            }
                            return new Object[]{1000};
                        }
                        ITankContainer container = (ITankContainer)te;
                        ForgeDirection side = ForgeDirection.getOrientation((int)mop.e);
                        LiquidStack removing = PeripheralTank.this.liquid.copy();
                        removing.amount = Math.min(doAmount, PeripheralTank.this.liquid.amount);
                        int removed = container.fill(side, removing, true);
                        PeripheralTank.this.liquid.amount -= removed;
                        if (PeripheralTank.this.liquid.amount <= 0) {
                            PeripheralTank.this.liquid = null;
                        }
                        PeripheralTank.this.updateLiquid();
                        return removed;
                    }
                });
                return new Object[]{callback.get()};
            }
            case 6: {
                if (this.liquid == null) {
                    return new Object[]{null, 0};
                }
                return new Object[]{Util.getUUID(this.liquid), this.liquid.amount};
            }
            case 7: {
                if (this.liquid == null || this.liquid.amount < 1000) {
                    return new Object[]{false};
                }
                ur slotstack = this.turtle.getSlotContents(this.turtle.getSelectedSlot());
                if (slotstack == null) {
                    return new Object[]{false};
                }
                LiquidStack filling = this.liquid.copy();
                filling.amount = 1000;
                ur filled = LiquidContainerRegistry.fillLiquidContainer((LiquidStack)filling, (ur)slotstack);
                if (filled != null) {
                    this.liquid.amount -= filling.amount;
                    if (this.liquid.amount <= 0) {
                        this.liquid = null;
                    }
                    --slotstack.a;
                    if (slotstack.a <= 0) {
                        slotstack = null;
                    }
                    this.turtle.setSlotContents(this.turtle.getSelectedSlot(), slotstack);
                    Util.storeOrDrop(this.turtle, filled);
                    return new Object[]{true};
                }
                return new Object[]{false};
            }
            case 8: {
                ur slotstack = this.turtle.getSlotContents(this.turtle.getSelectedSlot());
                if (slotstack == null) {
                    return new Object[]{false};
                }
                for (LiquidContainerData data : LiquidContainerRegistry.getRegisteredLiquidContainerData()) {
                    if (!data.filled.a(slotstack) || this.liquid != null && (!this.liquid.isLiquidEqual(data.stillLiquid) || 10000 - this.liquid.amount < data.stillLiquid.amount)) continue;
                    if (this.liquid == null) {
                        this.liquid = data.stillLiquid.copy();
                    } else {
                        this.liquid.amount += data.stillLiquid.amount;
                    }
                    if (slotstack.b().s()) {
                        slotstack = slotstack.b().getContainerItemStack(slotstack);
                    } else {
                        --slotstack.a;
                        if (slotstack.a <= 0) {
                            slotstack = null;
                        }
                    }
                    this.turtle.setSlotContents(this.turtle.getSelectedSlot(), slotstack);
                    return new Object[]{true};
                }
                return new Object[]{false};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return false;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
    }

    public void detach(IComputerAccess computer) {
    }

    public void update() {
        if (this.turtle.getWorld() != null && !this.turtle.getWorld().I && ++this.ticker >= 20) {
            this.ticker = 0;
            this.updateLiquid();
        }
    }

    public void readFromNBT(bq nbttagcompound) {
        if (nbttagcompound.b("liquid")) {
            this.liquid = LiquidStack.loadLiquidStackFromNBT((bq)nbttagcompound.l("liquid"));
        }
    }

    public void writeToNBT(bq nbttagcompound) {
        if (this.liquid != null) {
            bq liquid = new bq();
            this.liquid.writeToNBT(liquid);
            nbttagcompound.a("liquid", (cd)liquid);
        }
    }

    @Override
    public int getLightLevel() {
        if (this.liquid != null && this.liquid.itemID == amq.G.cm) {
            return Math.round((float)this.liquid.amount / 10000.0f * 15.0f);
        }
        return 0;
    }

    private void updateLiquid() {
        if (!this.areLiquidsEqual(this.liquid, this.prevLiquid)) {
            yc world = this.turtle.getWorld();
            aoj pos = this.turtle.getPosition();
            int x = (int)Math.floor(pos.c);
            int y = (int)Math.floor(pos.d);
            int z = (int)Math.floor(pos.e);
            world.i(x, y, z);
            this.prevLiquid = this.liquid == null ? null : this.liquid.copy();
            ByteArrayDataOutput os = ByteStreams.newDataOutput();
            os.writeInt(x);
            os.writeInt(y);
            os.writeInt(z);
            if (this.liquid == null) {
                os.writeShort(Short.MIN_VALUE);
                os.writeShort(Short.MIN_VALUE);
                os.writeInt(Integer.MIN_VALUE);
            } else {
                os.writeShort(this.liquid.itemID);
                os.writeShort(this.liquid.itemMeta);
                os.writeInt(this.liquid.amount);
            }
            PacketDispatcher.sendPacketToAllAround((double)(pos.c + 0.5), (double)(pos.d + 0.5), (double)(pos.e + 0.5), (double)64.0, (int)world.u.h, (ef)PacketDispatcher.getTinyPacket((Object)MiscPeripherals.instance, (short)2, (byte[])os.toByteArray()));
        }
    }

    private boolean areLiquidsEqual(LiquidStack a, LiquidStack b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.itemID == b.itemID && a.itemMeta == b.itemMeta && a.amount == b.amount;
    }

    public int getTankPressure() {
        return 0;
    }

    public LiquidStack getLiquid() {
        return this.liquid;
    }

    public int getCapacity() {
        return 10000;
    }

    public int fill(LiquidStack resource, boolean doFill) {
        if (this.liquid != null && !resource.isLiquidEqual(this.liquid)) {
            return 0;
        }
        int toAdd = Math.min(10000 - (this.liquid == null ? 0 : this.liquid.amount), resource.amount);
        if (toAdd < 0) {
            toAdd = 0;
        }
        if (doFill) {
            if (this.liquid == null) {
                this.liquid = resource.copy();
                this.liquid.amount = toAdd;
            } else {
                this.liquid.amount += toAdd;
            }
            if (toAdd != 0) {
                this.updateLiquid();
            }
        }
        return toAdd;
    }

    public LiquidStack drain(int maxDrain, boolean doDrain) {
        if (this.liquid == null) {
            return null;
        }
        LiquidStack ret = this.liquid.copy();
        ret.amount = Math.min(this.liquid.amount, maxDrain);
        if (doDrain) {
            this.liquid.amount -= ret.amount;
            if (this.liquid.amount <= 0) {
                this.liquid = null;
            }
            if (ret.amount != 0) {
                this.updateLiquid();
            }
        }
        return ret;
    }

    @Override
    public boolean canUseFromSide(ForgeDirection side) {
        if (!MiscPeripherals.instance.sideSensitive) {
            return true;
        }
        ForgeDirection myside = Util.getDirectionFromTurtleSide(Util.getPeripheralSide(this.turtle, PeripheralTank.class), this.turtle.getFacingDir());
        return side == myside || side == ForgeDirection.UNKNOWN;
    }
}

