/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import miscperipherals.core.LuaManager;
import miscperipherals.safe.Reflector;
import miscperipherals.util.Util;
import thaumcraft.api.AuraNode;
import thaumcraft.api.EnumTag;
import thaumcraft.api.IAspectSource;
import thaumcraft.api.ObjectTags;
import thaumcraft.api.ThaumcraftApi;

public class PeripheralThaumScanner
implements IHostedPeripheral {
    private final ITurtleAccess turtle;

    public PeripheralThaumScanner(ITurtleAccess turtle) {
        this.turtle = turtle;
    }

    public String getType() {
        return "thaumScanner";
    }

    public String[] getMethodNames() {
        return new String[]{"getAspects", "getAspectsUp", "getAspectsDown", "getItemAspects", "getAuraNodeDistance", "getAuraNode"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: 
            case 1: 
            case 2: {
                aoh mop = Util.rayTraceBlock(this.turtle, method == 0 ? this.turtle.getFacingDir() : (method == 1 ? 1 : 0));
                any tile = this.turtle.getWorld().q(mop.b, mop.c, mop.d);
                if (!(tile instanceof IAspectSource)) {
                    return new Object[]{null};
                }
                IAspectSource source = (IAspectSource)tile;
                ObjectTags tags = source.getSourceTags();
                HashMap aspects = new HashMap(tags.size());
                for (Map.Entry aspect : tags.tags.entrySet()) {
                    if ((Integer)aspect.getValue() <= 0) continue;
                    aspects.put(((EnumTag)aspect.getKey()).name, aspect.getValue());
                }
                return new Object[]{aspects};
            }
            case 3: {
                ur selstack = this.turtle.getSlotContents(this.turtle.getSelectedSlot());
                if (selstack == null) {
                    return new Object[]{null};
                }
                HashMap<String, Integer> aspects = new HashMap<String, Integer>();
                ObjectTags tags = (ObjectTags)ThaumcraftApi.objectTags.get(Arrays.asList(selstack.c, selstack.j()));
                if (tags == null) {
                    return new Object[]{aspects};
                }
                for (EnumTag aspect : tags.tags.keySet()) {
                    aspects.put(aspect.name, (Integer)tags.tags.get(aspect));
                }
                return new Object[]{aspects};
            }
            case 4: 
            case 5: {
                yc world = this.turtle.getWorld();
                aoj pos = this.turtle.getPosition();
                double closestDistance = Double.MAX_VALUE;
                Map auraNodes = (Map)Reflector.getField("thaumcraft.common.AuraManager", "auraNodes", Map.class);
                AuraNode closest = null;
                for (Integer key : (Iterable)Reflector.invoke("thaumcraft.common.AuraManager", "getAurasWithin", Iterable.class, world, pos.c, pos.d, pos.e)) {
                    double distance;
                    AuraNode node = (AuraNode)auraNodes.get(key);
                    if (node == null || !((distance = pos.d(world.S().a(node.xPos, node.yPos, node.zPos))) < closestDistance)) continue;
                    closestDistance = distance;
                    closest = node;
                }
                if (closest == null) {
                    return new Object[]{null, null, null, null, null};
                }
                int flux = 0;
                for (Integer fluxamount : closest.flux.tags.values()) {
                    flux += fluxamount.intValue();
                }
                return new Object[]{this.auraNodeHashCode(closest), closestDistance, closest.baseLevel, flux, Util.camelCase(closest.type.name())};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return false;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
    }

    public void detach(IComputerAccess computer) {
    }

    public void update() {
    }

    public void readFromNBT(bq nbttagcompound) {
    }

    public void writeToNBT(bq nbttagcompound) {
    }

    private int auraNodeHashCode(AuraNode node) {
        return node.key;
    }
}

