/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.tile;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import java.util.HashMap;
import miscperipherals.core.LuaManager;
import miscperipherals.tile.TileInventory;
import miscperipherals.util.Util;

public class TileBeeAnalyzer
extends TileInventory
implements IPeripheral {
    public TileBeeAnalyzer() {
        super(1);
    }

    @Override
    public int getGuiId() {
        return 2;
    }

    @Override
    public String b() {
        return "Bee Analyzer";
    }

    public String getType() {
        return "beeAnalyzer";
    }

    public String[] getMethodNames() {
        return new String[]{"analyze", "isBee"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                ur beeItem = this.a(0);
                if (beeItem == null || !BeeManager.beeInterface.isBee(beeItem)) {
                    return new Object[]{null};
                }
                IBee bee = BeeManager.beeInterface.getBee(beeItem);
                if (!bee.isAnalyzed()) {
                    return new Object[]{null};
                }
                IBeeGenome genome = bee.getGenome();
                HashMap<String, Object> ret = new HashMap<String, Object>();
                ret.put("type", BeeManager.beeInterface.isDrone(beeItem) ? "drone" : (BeeManager.beeInterface.isMated(beeItem) ? "queen" : "princess"));
                ret.put("speciesPrimary", genome.getPrimary().getName());
                ret.put("speciesSecondary", genome.getSecondary().getName());
                ret.put("speed", Float.valueOf(genome.getSpeed()));
                ret.put("lifespan", genome.getLifespan());
                ret.put("fertility", genome.getFertility());
                ret.put("nocturnal", genome.getNocturnal());
                ret.put("tolerantFlyer", genome.getTolerantFlyer());
                ret.put("caveDwelling", genome.getCaveDwelling());
                ret.put("flower", genome.getFlowerProvider().getDescription());
                ret.put("territory", Util.arrayToMap(genome.getTerritory()));
                ret.put("effect", genome.getEffect().getIdentifier());
                ret.put("temperature", genome.getPrimary().getTemperature().toString());
                ret.put("toleranceTemperature", genome.getToleranceTemp().toString());
                ret.put("humidity", genome.getPrimary().getHumidity().toString());
                ret.put("toleranceHumidity", genome.getToleranceHumid().toString());
                return new Object[]{ret};
            }
            case 1: {
                ur beeItem = this.a(0);
                if (beeItem == null || !BeeManager.beeInterface.isBee(beeItem)) {
                    return new Object[]{false};
                }
                return new Object[]{true};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
    }

    public void detach(IComputerAccess computer) {
    }
}

