/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.tile;

import cpw.mods.fml.common.FMLCommonHandler;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import miscperipherals.api.IInteractiveSorterOutput;
import miscperipherals.core.LuaManager;
import miscperipherals.core.TickHandler;
import miscperipherals.tile.TileInventory;
import miscperipherals.util.Util;
import net.minecraftforge.common.ForgeDirection;

public class TileInteractiveSorter
extends TileInventory
implements IPeripheral {
    private Map computers = new WeakHashMap();
    private ur lastStack;
    private int direction = -1;
    private int amount = 0;
    private int activeTicks = 0;
    private boolean tcDone = false;

    public TileInteractiveSorter() {
        super(1);
    }

    @Override
    public void a(bq compound) {
        super.a(compound);
        if (compound.b("lastStack")) {
            this.lastStack = ur.a((bq)compound.l("lastStack"));
        }
    }

    @Override
    public void b(bq compound) {
        super.b(compound);
        if (this.lastStack != null) {
            bq lastStackCompound = new bq();
            this.lastStack.b(lastStackCompound);
            compound.a("lastStack", lastStackCompound);
        }
    }

    public void d() {
        ur stack = this.a(0);
        if (stack != null && stack != this.lastStack) {
            this.lastStack = stack;
            for (IComputerAccess computer : this.computers.keySet()) {
                computer.queueEvent("isort_item", new Object[]{Util.getUUID(stack), stack.a});
            }
        }
    }

    public String getType() {
        return "interactiveSorter";
    }

    public String[] getMethodNames() {
        return new String[]{"sort", "list", "extract", "getItem"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                if (arguments.length < 1) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                if (arguments.length > 1 && !(arguments[1] instanceof Double)) {
                    throw new Exception("bad argument #2 (expected number)");
                }
                int direction = (int)Math.floor((Double)arguments[0]);
                if (direction < 0 || direction > 5) {
                    throw new Exception("bad direction " + direction + " (expected 0-5)");
                }
                while (this.direction != -1) {
                    Thread.sleep(10L);
                }
                ur stack = this.a(0);
                if (stack == null) {
                    return new Object[]{false};
                }
                this.amount = arguments.length > 1 ? (int)Math.floor((Double)arguments[1]) : stack.a;
                if (this.amount < 1 || this.amount > stack.a) {
                    return new Object[]{false};
                }
                this.direction = direction;
                return new Object[]{true};
            }
            case 1: {
                if (arguments.length < 1) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                final int direction = (int)Math.floor((Double)arguments[0]);
                if (direction < 0 || direction > 5) {
                    throw new Exception("bad direction " + direction + " (expected 0-5)");
                }
                Future callback = TickHandler.addTickCallback(this.k, new Callable(){

                    public Map call() {
                        any te = TileInteractiveSorter.this.k.q(TileInteractiveSorter.this.l + r.b[direction], TileInteractiveSorter.this.m + r.c[direction], TileInteractiveSorter.this.n + r.d[direction]);
                        if (!(te instanceof la)) {
                            return null;
                        }
                        HashMap<Long, Integer> items = new HashMap<Long, Integer>();
                        la inv = (la)te;
                        for (int i = 0; i < inv.k_(); ++i) {
                            ur slotstack = inv.a(i);
                            if (slotstack == null) continue;
                            long uuid = Util.getUUID(slotstack);
                            if (items.containsKey(uuid)) {
                                items.put(uuid, (Integer)items.get(uuid) + slotstack.a);
                                continue;
                            }
                            items.put(uuid, slotstack.a);
                        }
                        return items;
                    }
                });
                return new Object[]{callback.get()};
            }
            case 2: {
                if (arguments.length < 3) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                if (!(arguments[1] instanceof Double)) {
                    throw new Exception("bad argument #2 (expected number)");
                }
                if (!(arguments[2] instanceof Double)) {
                    throw new Exception("bad argument #3 (expected number)");
                }
                final int direction = (int)Math.floor((Double)arguments[0]);
                if (direction < 0 || direction > 5) {
                    throw new Exception("bad direction " + direction + " (expected 0-5)");
                }
                final int uuid = (int)Math.floor((Double)arguments[1]);
                final int outDir = (int)Math.floor((Double)arguments[2]);
                if (outDir < 0 || outDir > 5) {
                    throw new Exception("bad output direction " + direction + " (expected 0-5)");
                }
                int tamount = Integer.MIN_VALUE;
                if (arguments.length > 3) {
                    if (!(arguments[3] instanceof Double)) {
                        throw new Exception("bad argument #4 (expected number)");
                    }
                    tamount = Math.abs((int)Math.floor((Double)arguments[3]));
                }
                final int amount = tamount;
                Future callback = TickHandler.addTickCallback(this.k, new Callable(){

                    public Integer call() {
                        int i;
                        any te = TileInteractiveSorter.this.k.q(TileInteractiveSorter.this.l + r.b[direction], TileInteractiveSorter.this.m + r.c[direction], TileInteractiveSorter.this.n + r.d[direction]);
                        if (!(te instanceof la)) {
                            return 0;
                        }
                        ArrayList<ur> stacks = new ArrayList<ur>();
                        int remain = amount;
                        la inv = (la)te;
                        for (i = 0; i < inv.k_(); ++i) {
                            ur slotstack = inv.a(i);
                            if (slotstack == null || Util.getUUID(slotstack) != uuid) continue;
                            int adding = Math.min(slotstack.a, remain);
                            remain -= adding;
                            ur output = slotstack.l();
                            output.a = adding;
                            stacks.add(output);
                            slotstack.a -= adding;
                            if (slotstack.a <= 0) {
                                slotstack = null;
                            }
                            inv.a(i, slotstack);
                            if (remain <= 0) break;
                        }
                        for (i = 0; i < stacks.size(); ++i) {
                            TileInteractiveSorter.this.outputItem((ur)stacks.get(i), outDir);
                        }
                        return amount - remain;
                    }
                });
                return new Object[]{callback.get()};
            }
            case 5: {
                ur stack = this.a(0);
                if (stack == null) {
                    return new Object[]{null, 0};
                }
                return new Object[]{Util.getUUID(stack), stack.a};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
        this.computers.put(computer, true);
    }

    public void detach(IComputerAccess computer) {
        this.computers.remove(computer);
    }

    public boolean canUpdate() {
        return !FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    public void g() {
        super.g();
        if (this.activeTicks > 0) {
            if (--this.activeTicks <= 0) {
                this.setActive(false);
            } else {
                this.setActive(true);
            }
        }
        if (this.direction > -1) {
            ur stack = this.a(0);
            int oldSize = stack.a;
            stack.a = this.amount;
            this.outputItem(stack, this.direction);
            stack.a = oldSize - this.amount;
            if (stack.a <= 0) {
                stack = null;
            }
            this.a(0, stack);
            this.activeTicks = 10;
            this.direction = -1;
        }
    }

    @Override
    public int getGuiId() {
        return 2;
    }

    @Override
    public String b() {
        return "Interactive Sorter";
    }

    private void outputItem(ur stack, int direction) {
        for (IInteractiveSorterOutput output : IInteractiveSorterOutput.handlers) {
            output.output(stack, this.k, this.l, this.m, this.n, direction);
            if (stack.a > 0) continue;
            break;
        }
        if (stack.a > 0) {
            float xoff = this.k.t.nextFloat() * 0.8f + 0.1f + 0.5f * (float)r.b[direction];
            float yoff = this.k.t.nextFloat() * 0.8f + 0.1f + 0.5f * (float)r.c[direction];
            float zoff = this.k.t.nextFloat() * 0.8f + 0.1f + 0.5f * (float)r.d[direction];
            px item = new px(this.k, (double)((float)this.l + xoff), (double)((float)this.m + yoff), (double)((float)this.n + zoff), stack.l());
            item.b = 10;
            item.w = (float)this.k.t.nextGaussian() * 0.05f + (float)r.b[direction];
            item.x = (float)this.k.t.nextGaussian() * 0.05f + (float)r.c[direction];
            item.y = (float)this.k.t.nextGaussian() * 0.05f + (float)r.d[direction];
            this.k.d((lq)item);
            stack.a = 0;
        }
    }

    static {
        IInteractiveSorterOutput.handlers.add(new InventoryInteractiveSorterOutput());
    }

    public static class InventoryInteractiveSorterOutput
    implements IInteractiveSorterOutput {
        @Override
        public void output(ur stack, yc world, int posX, int posY, int posZ, int direction) {
            any te = world.q(posX + r.b[direction], posY + r.c[direction], posZ + r.d[direction]);
            if (stack != null && te instanceof la) {
                la inv = (la)te;
                int invDirection = ForgeDirection.getOrientation((int)direction).getOpposite().ordinal();
                int start = Util.getInventoryStart(inv, invDirection);
                int size = Util.getInventorySize(inv, invDirection);
                for (int slot = start; slot < start + size; ++slot) {
                    ur put;
                    ur slotStack = inv.a(slot);
                    if (slotStack == null) {
                        put = stack.l();
                        put.a = Math.min(stack.a, inv.c());
                        inv.a(slot, put);
                        stack.a -= put.a;
                        if (stack.a > 0) continue;
                        break;
                    }
                    if (!Util.areStacksEqual(slotStack, stack)) continue;
                    put = slotStack.l();
                    int toPut = Math.min(stack.a, Math.min(slotStack.d() - slotStack.a, inv.c() - slotStack.a));
                    put.a += toPut;
                    inv.a(slot, put);
                    stack.a -= toPut;
                    if (stack.a <= 0) break;
                }
            }
        }
    }
}

