/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.tile;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import miscperipherals.core.LuaManager;
import miscperipherals.core.TickHandler;
import miscperipherals.inventory.ISlotController;
import miscperipherals.inventory.SlotControlled;
import miscperipherals.safe.ReflectionStore;
import miscperipherals.tile.TileInventory;
import shedar.mods.ic2.nuclearcontrol.api.CardState;
import shedar.mods.ic2.nuclearcontrol.api.ICardWrapper;
import shedar.mods.ic2.nuclearcontrol.api.IPanelDataSource;
import shedar.mods.ic2.nuclearcontrol.panel.CardWrapperImpl;

public class TileNuclearReader
extends TileInventory
implements IPeripheral,
ISlotController {
    private static final int SHIPPED_RANGE_UPGRADES = 2;
    private static final int MAX_RANGE_UPGRADES = 7;
    private static final int BASE_RANGE = 8;

    public TileNuclearReader() {
        this(1);
    }

    public TileNuclearReader(int slots) {
        super(slots);
    }

    @Override
    public boolean isItemValid(SlotControlled slot, ur item) {
        return item.b() instanceof IPanelDataSource || ReflectionStore.itemUpgrade != null && ReflectionStore.damageRange != null && item.b().getClass() == ReflectionStore.itemUpgrade.getClass() && item.j() == ReflectionStore.damageRange.intValue();
    }

    @Override
    public String b() {
        return "Nuclear Information Reader";
    }

    public String getType() {
        return "nuclearReader";
    }

    public String[] getMethodNames() {
        return new String[]{"get", "getSlots"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                if (arguments.length < 1) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                final int slot = (int)Math.floor((Double)arguments[0]) - 1;
                if (slot < 0 || slot >= this.inventory.length) {
                    throw new Exception("bad slot " + (slot + 1) + " (expected 1-" + this.inventory.length + ")");
                }
                if (this.inventory[slot] == null) {
                    return new Object[]{null, null, null, null};
                }
                Future callback = TickHandler.addTickCallback(this.k, new Callable(){

                    public Object[] call() {
                        int rangeUpgrades = 2;
                        for (int i = 0; i < TileNuclearReader.this.inventory.length; ++i) {
                            if (TileNuclearReader.this.inventory[i] == null || ReflectionStore.itemUpgrade == null || ReflectionStore.damageRange == null || TileNuclearReader.this.inventory[i].b().getClass() != ReflectionStore.itemUpgrade.getClass() || TileNuclearReader.this.inventory[i].j() != ReflectionStore.damageRange.intValue()) continue;
                            rangeUpgrades += TileNuclearReader.this.inventory[i].a;
                        }
                        if (rangeUpgrades > 7) {
                            rangeUpgrades = 7;
                        }
                        if (TileNuclearReader.this.inventory[slot] != null && TileNuclearReader.this.inventory[slot].b() instanceof IPanelDataSource) {
                            HashMap map = new HashMap();
                            CardWrapperCommit cw = new CardWrapperCommit(TileNuclearReader.this, slot, map);
                            IPanelDataSource ds = (IPanelDataSource)TileNuclearReader.this.inventory[slot].b();
                            UUID uuid = ds.getCardType();
                            CardState state = ds.update((any)TileNuclearReader.this, (ICardWrapper)cw, 8 * (int)Math.pow(2.0, rangeUpgrades));
                            String title = cw.getTitle();
                            return new Object[]{uuid == null ? null : uuid.toString(), state.toString(), title, map};
                        }
                        return new Object[]{null, CardState.INVALID_CARD.toString(), null, null};
                    }
                });
                return (Object[])callback.get();
            }
            case 1: {
                return new Object[]{this.inventory.length};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
    }

    public void detach(IComputerAccess computer) {
    }

    @Override
    public int getGuiId() {
        return 2;
    }

    public class CardWrapperCommit
    extends CardWrapperImpl {
        private final TileNuclearReader nr;
        private final int index;
        private final Map map;

        public CardWrapperCommit(TileNuclearReader nr, int index, Map map) {
            super(nr.inventory[index]);
            this.nr = nr;
            this.index = index;
            this.map = map;
        }

        public void setInt(String name, Integer value) {
            this.putValue(name, value);
        }

        public void setLong(String name, Long value) {
            this.putValue(name, value);
        }

        public void setString(String name, String value) {
            this.putValue(name, value);
        }

        public void setBoolean(String name, Boolean value) {
            this.putValue(name, value);
        }

        public void commit(any panel) {
        }

        private void putValue(String name, Object value) {
            this.map.put(name, value);
        }
    }
}

