/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.tile;

import cpw.mods.fml.common.FMLCommonHandler;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import java.util.logging.Level;
import miscperipherals.api.IMinecartData;
import miscperipherals.core.LuaManager;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.tile.Tile;

public class TileRailReader
extends Tile
implements IPeripheral {
    private static final int TICK_RATE = 5;
    private final Map computers = new WeakHashMap();
    private final Map carts = new WeakHashMap();
    private int ticker = new Random().nextInt(5);

    public boolean canUpdate() {
        return !FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    public void g() {
        if (++this.ticker > 5) {
            this.ticker = 0;
            double rangeSub = 0.125;
            List carts = this.k.a(py.class, aoe.a().a((double)this.l + rangeSub, (double)(this.m + 1), (double)this.n + rangeSub, (double)(this.l + 1) - rangeSub, (double)(this.m + 2) - rangeSub, (double)(this.n + 1) - rangeSub));
            LinkedList<py> toRemove = new LinkedList<py>();
            for (py cart : this.carts.keySet()) {
                if (carts.contains(cart)) continue;
                toRemove.add(cart);
            }
            for (py cart : toRemove) {
                this.carts.remove(cart);
            }
            for (py cart : carts) {
                if (this.carts.containsKey(cart)) continue;
                this.carts.put(cart, true);
                String cartType = "unknown";
                Map cartData = null;
                for (IMinecartData handler : IMinecartData.handlers) {
                    try {
                        Map retData = handler.getMinecartData(cart);
                        if (retData == null) continue;
                        cartData = retData;
                        break;
                    }
                    catch (Throwable e) {
                        MiscPeripherals.log.log(Level.WARNING, "Error processing minecart data handler " + handler, e);
                    }
                }
                if (cartData != null && cartData.containsKey("__CART_TYPE__")) {
                    cartType = (String)cartData.get("__CART_TYPE__");
                    cartData.remove("__CART_TYPE__");
                }
                for (IComputerAccess computer : this.computers.keySet()) {
                    computer.queueEvent("minecart", new Object[]{cartType, cart.k, cartData});
                }
            }
        }
    }

    public String getType() {
        return "railReader";
    }

    public String[] getMethodNames() {
        return new String[0];
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
        this.computers.put(computer, true);
    }

    public void detach(IComputerAccess computer) {
        this.computers.remove(computer);
    }

    static {
        IMinecartData.handlers.add(new VanillaMinecartData());
    }

    public static class VanillaMinecartData
    implements IMinecartData {
        @Override
        public Map getMinecartData(py cart) {
            if (cart.getClass() == py.class) {
                HashMap<String, Object> ret = new HashMap<String, Object>();
                switch (cart.a) {
                    case 0: {
                        ret.put("__CART_TYPE__", "basic");
                        ret.put("occupied", cart.n != null);
                        if (cart.n == null) break;
                        ret.put("username", cart.n.an());
                        break;
                    }
                    case 1: {
                        ret.put("__CART_TYPE__", "storage");
                        break;
                    }
                    case 2: {
                        ret.put("__CART_TYPE__", "furnace");
                        bq workaround = new bq();
                        cart.d(workaround);
                        ret.put("fuel", workaround.e("Fuel"));
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                return ret;
            }
            return null;
        }
    }
}

