/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.tile;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.TreeManager;
import java.util.ArrayList;
import java.util.HashMap;
import miscperipherals.core.LuaManager;
import miscperipherals.tile.TileInventory;
import miscperipherals.util.Util;
import net.minecraftforge.common.EnumPlantType;

public class TileTreeAnalyzer
extends TileInventory
implements IPeripheral {
    public TileTreeAnalyzer() {
        super(1);
    }

    @Override
    public int getGuiId() {
        return 2;
    }

    @Override
    public String b() {
        return "Tree Analyzer";
    }

    public String getType() {
        return "treeAnalyzer";
    }

    public String[] getMethodNames() {
        return new String[]{"analyze", "isTree"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                ur treeItem = this.a(0);
                if (treeItem == null || !TreeManager.treeInterface.isGermling(treeItem)) {
                    return new Object[]{null};
                }
                ITree tree = TreeManager.treeInterface.getTree(treeItem);
                if (!tree.isAnalyzed()) {
                    return new Object[]{null};
                }
                ITreeGenome genome = tree.getGenome();
                HashMap<String, Object> ret = new HashMap<String, Object>();
                ret.put("speciesPrimary", genome.getPrimary().getName());
                ret.put("speciesSecondary", genome.getSecondary().getName());
                ret.put("height", Float.valueOf(genome.getHeight()));
                ret.put("fertility", Float.valueOf(genome.getFertility()));
                ret.put("yield", Float.valueOf(genome.getYield()));
                ret.put("fruit", genome.getFruitProvider().getDescription());
                ret.put("growth", genome.getGrowthProvider().getDescription());
                ret.put("girth", genome.getPrimaryAsTree().getGirth());
                ret.put("plant", genome.getPrimaryAsTree().getPlantType().toString());
                ArrayList<String> plants = new ArrayList<String>(genome.getPlantTypes().size());
                for (EnumPlantType plant : genome.getPlantTypes()) {
                    plants.add(plant.toString());
                }
                ret.put("tolerancePlants", Util.listToMap(plants));
                return new Object[]{ret};
            }
            case 1: {
                ur treeItem = this.a(0);
                if (treeItem == null || !TreeManager.treeInterface.isGermling(treeItem)) {
                    return new Object[]{false};
                }
                return new Object[]{true};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
    }

    public void detach(IComputerAccess computer) {
    }
}

