/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.upgrade;

import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import dan200.turtle.api.ITurtleUpgrade;
import dan200.turtle.api.TurtleSide;
import dan200.turtle.api.TurtleUpgradeType;
import dan200.turtle.api.TurtleVerb;
import miscperipherals.api.IUpgradeRender;
import miscperipherals.peripheral.PeripheralAnvil;

public class UpgradeAnvil
implements ITurtleUpgrade,
IUpgradeRender {
    public int getUpgradeID() {
        return 242;
    }

    public String getAdjective() {
        return "Anvil";
    }

    public TurtleUpgradeType getType() {
        return TurtleUpgradeType.Peripheral;
    }

    public ur getCraftingItem() {
        return new ur(amq.ck, 1, -1);
    }

    public boolean isSecret() {
        return false;
    }

    public String getIconTexture(ITurtleAccess turtle, TurtleSide side) {
        return amq.ck.getTextureFile();
    }

    public int getIconIndex(ITurtleAccess turtle, TurtleSide side) {
        return amq.ck.cl;
    }

    public IHostedPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return new PeripheralAnvil(turtle, side);
    }

    public boolean useTool(ITurtleAccess turtle, TurtleSide side, TurtleVerb verb, int direction) {
        return false;
    }

    @Override
    public int getRenderPasses(ITurtleAccess turtle, TurtleSide side) {
        return turtle == null ? 1 : 2;
    }

    @Override
    public String getTextureForPass(ITurtleAccess turtle, TurtleSide side, int pass) {
        return this.getIconTexture(turtle, side);
    }

    @Override
    public int getIconForPass(ITurtleAccess turtle, TurtleSide side, int pass) {
        if (pass == 0) {
            return this.getIconIndex(turtle, side);
        }
        if (turtle == null) {
            return 180;
        }
        IHostedPeripheral peripheral = turtle.getPeripheral(side);
        if (!(peripheral instanceof PeripheralAnvil)) {
            return 180;
        }
        int index = 239 + (int)Math.floor(10.0f * ((float)((PeripheralAnvil)peripheral).damage / 2.0f));
        return index == 239 ? 180 : index;
    }

    @Override
    public int getColorForPass(ITurtleAccess turtle, TurtleSide side, int pass) {
        return 0xFFFFFF;
    }
}

