/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.upgrade;

import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import dan200.turtle.api.ITurtleUpgrade;
import dan200.turtle.api.TurtleSide;
import dan200.turtle.api.TurtleUpgradeType;
import dan200.turtle.api.TurtleVerb;
import miscperipherals.peripheral.PeripheralBarrel;
import miscperipherals.safe.ReflectionStore;

public class UpgradeBarrel
implements ITurtleUpgrade {
    public int getUpgradeID() {
        return 243;
    }

    public String getAdjective() {
        return "Barrel";
    }

    public TurtleUpgradeType getType() {
        return TurtleUpgradeType.Peripheral;
    }

    public ur getCraftingItem() {
        return ReflectionStore.barrel_item == null ? new ur(amq.ax) : ReflectionStore.barrel_item.l();
    }

    public boolean isSecret() {
        return false;
    }

    public String getIconTexture(ITurtleAccess turtle, TurtleSide side) {
        return "/miscperipherals/sprite/sprites.png";
    }

    public int getIconIndex(ITurtleAccess turtle, TurtleSide side) {
        if (turtle == null) {
            return 96;
        }
        IHostedPeripheral peripheral = turtle.getPeripheral(side);
        if (!(peripheral instanceof PeripheralBarrel)) {
            return 96;
        }
        PeripheralBarrel barrel = (PeripheralBarrel)peripheral;
        if (barrel.clientAmount == 0) {
            return 96;
        }
        if (barrel.clientAmount == barrel.maxSize) {
            return 111;
        }
        return 97 + (int)Math.ceil((double)barrel.clientAmount / (double)barrel.maxSize) * 14;
    }

    public IHostedPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return new PeripheralBarrel(turtle);
    }

    public boolean useTool(ITurtleAccess turtle, TurtleSide side, TurtleVerb verb, int direction) {
        return false;
    }
}

