/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.upgrade;

import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import dan200.turtle.api.ITurtleUpgrade;
import dan200.turtle.api.TurtleSide;
import dan200.turtle.api.TurtleUpgradeType;
import dan200.turtle.api.TurtleVerb;
import java.util.HashMap;
import java.util.Map;
import miscperipherals.api.IUpgradeRender;
import miscperipherals.peripheral.PeripheralTank;
import miscperipherals.util.Util;

public class UpgradeTank
implements ITurtleUpgrade,
IUpgradeRender {
    public static final ur[] CRAFTING_ITEM;
    public static final int GAUGE_MAXIMUM = 10;
    public static final Map LIQUIDS;
    public static final Map KNOWN_LIQUIDS;

    public int getUpgradeID() {
        return 217;
    }

    public String getAdjective() {
        return "Tank";
    }

    public TurtleUpgradeType getType() {
        return TurtleUpgradeType.Peripheral;
    }

    public ur getCraftingItem() {
        ur item = (ur)Util.getFirstElement(CRAFTING_ITEM);
        return item == null ? new ur(amq.P) : item;
    }

    public boolean isSecret() {
        return false;
    }

    public String getIconTexture(ITurtleAccess turtle, TurtleSide side) {
        return "/miscperipherals/sprite/sprites.png";
    }

    public int getIconIndex(ITurtleAccess turtle, TurtleSide side) {
        IHostedPeripheral peripheral;
        if (turtle != null && (peripheral = turtle.getPeripheral(side)) instanceof PeripheralTank) {
            PeripheralTank tank = (PeripheralTank)peripheral;
            if (tank.liquid != null) {
                return this.getTextureIndex(tank) + 16;
            }
        }
        return 64;
    }

    public IHostedPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return new PeripheralTank(turtle);
    }

    public boolean useTool(ITurtleAccess turtle, TurtleSide side, TurtleVerb verb, int direction) {
        return false;
    }

    @Override
    public int getRenderPasses(ITurtleAccess turtle, TurtleSide side) {
        return 2;
    }

    @Override
    public String getTextureForPass(ITurtleAccess turtle, TurtleSide side, int pass) {
        return this.getIconTexture(turtle, side);
    }

    @Override
    public int getIconForPass(ITurtleAccess turtle, TurtleSide side, int pass) {
        IHostedPeripheral peripheral;
        if (pass == 0) {
            return 64;
        }
        if (turtle != null && (peripheral = turtle.getPeripheral(side)) instanceof PeripheralTank) {
            PeripheralTank tank = (PeripheralTank)peripheral;
            if (tank.liquid != null) {
                return this.getTextureIndex(tank);
            }
        }
        return 48;
    }

    @Override
    public int getColorForPass(ITurtleAccess turtle, TurtleSide side, int pass) {
        IHostedPeripheral peripheral;
        if (pass == 0) {
            return 0xFFFFFF;
        }
        if (turtle != null && (peripheral = turtle.getPeripheral(side)) instanceof PeripheralTank) {
            String name;
            xv pair;
            PeripheralTank tank = (PeripheralTank)peripheral;
            if (tank.liquid != null && LIQUIDS.containsKey(pair = new xv(tank.liquid.itemID, tank.liquid.itemMeta)) && KNOWN_LIQUIDS.containsKey(name = (String)LIQUIDS.get(pair))) {
                return (Integer)KNOWN_LIQUIDS.get(name);
            }
        }
        return 2514175;
    }

    private int getTextureIndex(PeripheralTank tank) {
        int gauge = (int)Math.ceil((double)tank.liquid.amount / 10000.0 * 10.0);
        return 48 + gauge;
    }

    static {
        int i;
        CRAFTING_ITEM = new ur[2];
        LIQUIDS = new HashMap();
        KNOWN_LIQUIDS = new HashMap();
        LIQUIDS.put(new xv(amq.E.cm, 0), "water");
        LIQUIDS.put(new xv(amq.G.cm, 0), "lava");
        KNOWN_LIQUIDS.put("water", 2514175);
        KNOWN_LIQUIDS.put("lava", 16738816);
        KNOWN_LIQUIDS.put("oil", 0);
        KNOWN_LIQUIDS.put("fuel", 12894222);
        KNOWN_LIQUIDS.put("biomass", 5816630);
        KNOWN_LIQUIDS.put("biofuel", 16751872);
        KNOWN_LIQUIDS.put("honey", 0xFFD000);
        KNOWN_LIQUIDS.put("seedoil", 16776603);
        KNOWN_LIQUIDS.put("juice", 12844800);
        KNOWN_LIQUIDS.put("mead", 13677165);
        KNOWN_LIQUIDS.put("ice", 10747895);
        KNOWN_LIQUIDS.put("milk", 0xFFFFFF);
        KNOWN_LIQUIDS.put("liquidglass", 0xD2D2D2);
        KNOWN_LIQUIDS.put("creosote oil", 0x6B6B00);
        KNOWN_LIQUIDS.put("steam", 0x404040);
        KNOWN_LIQUIDS.put("liquiduu", 12079032);
        KNOWN_LIQUIDS.put("liquidredstone", 0x1F0000);
        KNOWN_LIQUIDS.put("liquidender", 338981);
        KNOWN_LIQUIDS.put("coolant", 4383487);
        KNOWN_LIQUIDS.put("primer", 0x7D7D7D);
        String[] names = new String[]{"liquid nitrogen", "nitrogen gas", "liquidnitrogen"};
        for (i = 0; i < names.length; ++i) {
            KNOWN_LIQUIDS.put(names[i], 8453347);
        }
        names = new String[]{"black", "red", "green", "brown", "blue", "purple", "cyan", "light gray", "gray", "pink", "lime", "yellow", "light blue", "magenta", "orange", "white"};
        int[] colors = new int[]{0x191919, 0x993333, 6717235, 6704179, 3361970, 8339378, 5013401, 0x999999, 0x4C4C4C, 15892389, 8375321, 0xE5E533, 6724056, 11685080, 14188339, 0xFFFFFF};
        for (i = 0; i < names.length; ++i) {
            KNOWN_LIQUIDS.put("liquid " + names[i] + " dye", colors[i]);
            KNOWN_LIQUIDS.put("liquid " + names[i] + "dye", colors[i]);
            KNOWN_LIQUIDS.put("dye" + names[i].replaceAll(" ", ""), colors[i]);
        }
        names = new String[]{"iron", "gold", "copper", "tin", "silver", "lead", "diamond", "emerald", "obsidian", "bronze"};
        colors = new int[]{0x525252, 15060535, 7615238, 8026766, 0xA9A9A9, 0x151515, 7985359, 379728, 2432317, 12424486};
        for (i = 0; i < names.length; ++i) {
            KNOWN_LIQUIDS.put("molten " + names[i], colors[i]);
            KNOWN_LIQUIDS.put("molten" + names[i], colors[i]);
        }
        KNOWN_LIQUIDS.put("liquiddna", 16399352);
        KNOWN_LIQUIDS.put("acid", 10607883);
        KNOWN_LIQUIDS.put("poison", 14287834);
        KNOWN_LIQUIDS.put("pumpkin juice", 16758317);
        KNOWN_LIQUIDS.put("melon juice", 16731732);
        KNOWN_LIQUIDS.put("veggie juice", 15548929);
        KNOWN_LIQUIDS.put("mushroom soup", 13742193);
        KNOWN_LIQUIDS.put("living seedoil", 14474387);
        KNOWN_LIQUIDS.put("heavy water", 3951565);
        KNOWN_LIQUIDS.put("liquid peat", 3088149);
        KNOWN_LIQUIDS.put("radioactive waste", 12909106);
        KNOWN_LIQUIDS.put("sulfuric acid", 16771075);
        KNOWN_LIQUIDS.put("sugar syrup", 12353885);
        names = new String[]{"wolframium", "lithium", "silicon", "berylium", "calcium", "sodium", "chlorite", "potassium", "mercury", "sodiumpersulfate", "calciumcarbonate"};
        colors = new int[]{0x222028, 9551871, 4137996, 11776, 15355745, 2836644, 1664095, 10794421, 0xCAAAA3, 26435, 5967890};
        for (i = 0; i < names.length; ++i) {
            KNOWN_LIQUIDS.put("fluid" + names[i], colors[i]);
        }
        names = new String[]{"hydrogen", "deuterium", "tritium", "helium", "helium-3", "methane", "nitrogen"};
        colors = new int[]{134, 0xFFFF00, 0xC00000, 13490432, 0xFFFFDD, 15605309, 2988955};
        for (i = 0; i < names.length; ++i) {
            KNOWN_LIQUIDS.put("gas" + names[i], colors[i]);
        }
        KNOWN_LIQUIDS.put("tropics water", 7844837);
        KNOWN_LIQUIDS.put("sludge", 1315872);
        KNOWN_LIQUIDS.put("sewage", 6960173);
        KNOWN_LIQUIDS.put("mobessence", 25600);
    }
}

