/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.util;

import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import dan200.turtle.api.ITurtleUpgrade;
import dan200.turtle.api.TurtleSide;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.safe.Reflector;
import miscperipherals.tile.TileInventory;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import net.minecraftforge.liquids.LiquidStack;

public class Util {
    public static final int[] YAW = new int[]{0, 0, 180, 360, 90, 270};
    public static final int[] PITCH = new int[]{90, -90, 0, 0, 0, 0};
    public static final int[] SIDE_TO_FACE = new int[]{-1, -1, 2, 0, 1, 3};
    public static final int[] OPPOSITE = new int[]{1, 0, 3, 2, 5, 4};
    public static final Color[] MAP_COLORS = new Color[]{new Color(0, 0, 0), new Color(0, 0, 0), new Color(0, 0, 0), new Color(0, 0, 0), new Color(89, 125, 39), new Color(109, 153, 48), new Color(127, 178, 56), new Color(109, 153, 48), new Color(174, 164, 115), new Color(213, 201, 140), new Color(247, 233, 163), new Color(213, 201, 140), new Color(117, 117, 117), new Color(144, 144, 144), new Color(167, 167, 167), new Color(144, 144, 144), new Color(180, 0, 0), new Color(220, 0, 0), new Color(255, 0, 0), new Color(220, 0, 0), new Color(112, 112, 180), new Color(138, 138, 220), new Color(160, 160, 255), new Color(138, 138, 220), new Color(117, 117, 117), new Color(144, 144, 144), new Color(167, 167, 167), new Color(144, 144, 144), new Color(0, 87, 0), new Color(0, 106, 0), new Color(0, 124, 0), new Color(0, 106, 0), new Color(180, 180, 180), new Color(220, 220, 220), new Color(255, 255, 255), new Color(220, 220, 220), new Color(115, 118, 129), new Color(141, 144, 158), new Color(164, 168, 184), new Color(141, 144, 158), new Color(129, 74, 33), new Color(157, 91, 40), new Color(183, 106, 47), new Color(157, 91, 40), new Color(79, 79, 79), new Color(96, 96, 96), new Color(112, 112, 112), new Color(96, 96, 96), new Color(45, 45, 180), new Color(55, 55, 220), new Color(64, 64, 255), new Color(55, 55, 220), new Color(73, 58, 35), new Color(89, 71, 43), new Color(104, 83, 50), new Color(89, 71, 43)};
    public static final TurtleSide[] TURTLE_SIDES = TurtleSide.values();
    private static bq e = null;

    public static Map arrayToMap(int[] array) {
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        for (int i = 0; i < array.length; ++i) {
            ret.put(i + 1, array[i]);
        }
        return ret;
    }

    public static Map listToMap(List list) {
        HashMap ret = new HashMap();
        for (int i = 0; i < list.size(); ++i) {
            ret.put(i + 1, list.get(i));
        }
        return ret;
    }

    public static Map iterableToMap(Iterable iterable) {
        HashMap ret = new HashMap();
        int i = 1;
        for (Object item : iterable) {
            ret.put(i++, item);
        }
        return ret;
    }

    public static Object getFirstElement(List list) {
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            if (obj == null) continue;
            return obj;
        }
        return null;
    }

    public static Object getFirstElement(Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) continue;
            return array[i];
        }
        return null;
    }

    public static List merge(Collection ... collections) {
        int size = 0;
        for (Collection collection : collections) {
            size += collection.size();
        }
        ArrayList ret = new ArrayList(size);
        for (Collection collection : collections) {
            ret.addAll(collection);
        }
        return ret;
    }

    public static int getInventoryStart(la inv, int side) {
        if (inv instanceof ISidedInventory) {
            return ((ISidedInventory)inv).getStartInventorySide(ForgeDirection.getOrientation((int)side));
        }
        return 0;
    }

    public static int getInventorySize(la inv, int side) {
        if (inv instanceof ISidedInventory) {
            return ((ISidedInventory)inv).getSizeInventorySide(ForgeDirection.getOrientation((int)side));
        }
        return inv.k_();
    }

    public static List buildInventorySlotWhitelist(la inv) {
        ArrayList<Integer> ret = new ArrayList<Integer>(inv.k_());
        if (inv instanceof ISidedInventory) {
            ISidedInventory sidedinv = (ISidedInventory)inv;
            for (ForgeDirection direction : ForgeDirection.values()) {
                for (int i = sidedinv.getStartInventorySide(direction); i < sidedinv.getSizeInventorySide(direction); ++i) {
                    ret.add(i);
                }
            }
            if (inv.getClass() == anr.class) {
                ret.remove(2);
            }
        } else {
            for (int i = 0; i < inv.k_(); ++i) {
                ret.add(i);
            }
        }
        return ret;
    }

    public static aoe getAABB(ITurtleAccess turtle, int direction) {
        aoj pos = turtle.getPosition();
        return aoe.a().a(pos.c - 0.5, pos.d - 0.5, pos.e - 0.5, pos.c + 0.5 + 1.0 * (double)r.b[direction], pos.d + 0.5 + 1.0 * (double)r.c[direction], pos.e + 0.5 + 1.0 * (double)r.d[direction]);
    }

    public static void storeOrDrop(ITurtleAccess turtle, ur stack) {
        if (!turtle.storeItemStack(stack) && !turtle.dropItemStack(stack, OPPOSITE[turtle.getFacingDir()])) {
            turtle.dropItemStack(stack, turtle.getFacingDir());
        }
    }

    public static void storeOrDrop(TileInventory inv, ur stack) {
        for (int i = 0; i < inv.k_(); ++i) {
            ur slotstack = inv.a(i);
            if (slotstack != null && !Util.areStacksEqual(slotstack, stack)) continue;
            int add = Math.min(stack.a, slotstack == null ? Math.min(stack.d(), inv.c()) : slotstack.d() - slotstack.a);
            if (slotstack == null) {
                slotstack = stack.l();
            } else {
                slotstack.a += add;
            }
            stack.a -= add;
            inv.a(i, slotstack);
            if (stack.a > 0) continue;
            return;
        }
        int direction = 0;
        float xoff = inv.k.t.nextFloat() * 0.8f + 0.1f + 0.5f * (float)r.b[direction];
        float yoff = inv.k.t.nextFloat() * 0.8f + 0.1f + 0.5f * (float)r.c[direction];
        float zoff = inv.k.t.nextFloat() * 0.8f + 0.1f + 0.5f * (float)r.d[direction];
        px item = new px(inv.k, (double)((float)inv.l + xoff), (double)((float)inv.m + yoff), (double)((float)inv.n + zoff), stack);
        item.b = 10;
        item.w = (float)inv.k.t.nextGaussian() * 0.05f + (float)r.b[direction];
        item.x = (float)inv.k.t.nextGaussian() * 0.05f + (float)r.c[direction];
        item.y = (float)inv.k.t.nextGaussian() * 0.05f + (float)r.d[direction];
        inv.k.d((lq)item);
    }

    public static boolean areStacksEqual(ur stack1, ur stack2) {
        if (stack1 == null && stack2 == null) {
            return true;
        }
        if (stack1 == null || stack2 == null) {
            return false;
        }
        return stack1.c == stack2.c && (stack1.j() == -1 || stack2.j() == -1 || stack1.f() && stack2.f() || stack1.j() == stack2.j()) && ur.a((ur)stack1, (ur)stack2);
    }

    public static String camelCase(String in2) {
        String s2 = "";
        String[] split = in2.replace('_', ' ').split(" ");
        for (int i = 0; i < split.length; ++i) {
            s2 = i == 0 ? s2 + split[i].toLowerCase() : s2 + split[i].substring(0, 1).toUpperCase() + split[i].substring(1).toLowerCase();
        }
        return s2;
    }

    public static String sanitize(String s2, boolean allowColorCodes) {
        while (s2.endsWith("\u00a7")) {
            s2.substring(0, s2.length() - 1);
        }
        if (!allowColorCodes) {
            s2 = s2.replace('\u00a7', ' ').replace('\u0003', ' ').replace('\u0002', ' ').replace('\u001d', ' ').replace('\u001f', ' ').replace('\u0016', ' ');
        }
        s2 = s2.replace('\n', ' ').replace('\r', ' ').replace('\b', ' ').replace('\f', ' ').replace("\t", "    ");
        return s2;
    }

    public static int getXPFromLevel(int level) {
        return (int)(level <= 15 ? (double)(17 * level) : (level <= 30 ? 1.5 * (double)(level * level) - 29.5 * (double)level + 360.0 : 3.5 * (double)(level - level) - 151.5 * (double)level + 2220.0));
    }

    public static int getXPToAdvance(int level) {
        return level >= 30 ? 62 + (level - 30) * 7 : (level >= 15 ? 17 + (level - 15) * 3 : 17);
    }

    public static int getLevelFromXP(int xp) {
        int level = 0;
        while (xp >= 0) {
            if ((xp -= Util.getXPToAdvance(level)) < 0) continue;
            ++level;
        }
        return level;
    }

    public static Object getPeripheral(ITurtleAccess turtle, Class clazz) {
        for (TurtleSide side : TURTLE_SIDES) {
            IHostedPeripheral peripheral = turtle.getPeripheral(side);
            if (peripheral == null || !clazz.isAssignableFrom(peripheral.getClass())) continue;
            return peripheral;
        }
        return null;
    }

    public static TurtleSide getPeripheralSide(ITurtleAccess turtle, Class clazz) {
        for (TurtleSide side : TURTLE_SIDES) {
            IHostedPeripheral peripheral = turtle.getPeripheral(side);
            if (peripheral == null || !clazz.isAssignableFrom(peripheral.getClass())) continue;
            return side;
        }
        return null;
    }

    public static int addFuel(ITurtleAccess turtle, int amount) {
        if (Integer.MAX_VALUE - amount <= turtle.getFuelLevel()) {
            int added = Integer.MAX_VALUE - turtle.getFuelLevel();
            turtle.consumeFuel(-added);
            return added;
        }
        turtle.consumeFuel(-amount);
        return amount;
    }

    public static boolean teleportTurtleTo(ITurtleAccess turtle, yc world, int x, int y, int z) {
        aoj pos = turtle.getPosition();
        yc prevWorld = turtle.getWorld();
        int id = prevWorld.a((int)pos.c, (int)pos.d, (int)pos.e);
        int meta = prevWorld.h((int)pos.c, (int)pos.d, (int)pos.e);
        world.d(x, y, z, id, meta);
        any te = world.q(x, y, z);
        if (!(te instanceof ITurtleAccess)) {
            return false;
        }
        Reflector.setField(turtle, "m_moved", true);
        prevWorld.e((int)pos.c, (int)pos.d, (int)pos.e, 0);
        Reflector.invoke(te, "transferStateFrom", Object.class, turtle);
        prevWorld.j((int)pos.c, (int)pos.d, (int)pos.e);
        world.j(x, y, z);
        world.f(x, y, z, id);
        prevWorld.f((int)pos.c, (int)pos.d, (int)pos.e, 0);
        return true;
    }

    public static boolean isPassthroughBlock(yc world, int x, int y, int z) {
        if (y < 0 || y > 254) {
            return false;
        }
        int id = world.a(x, y, z);
        return amq.p[id] == null || amq.p[id].isAirBlock(world, x, y, z) || amq.p[id] instanceof akx || amq.p[id] instanceof amw || amq.p[id] instanceof amm;
    }

    public static void writeChunkCoordinatesToNBT(s coordinates, bq compound) {
        compound.a("x", coordinates.a);
        compound.a("y", coordinates.b);
        compound.a("z", coordinates.c);
    }

    public static s readChunkCoordinatesFromNBT(bq compound) {
        return new s(compound.e("x"), compound.e("y"), compound.e("z"));
    }

    public static ForgeDirection getDirectionFromTurtleSide(TurtleSide side, int facing) {
        if (side == null) {
            return null;
        }
        switch (side) {
            case Left: {
                return ForgeDirection.getOrientation((int)facing).getRotation(ForgeDirection.WEST);
            }
            case Right: {
                return ForgeDirection.getOrientation((int)facing).getRotation(ForgeDirection.EAST);
            }
        }
        return null;
    }

    public static String join(String separator, Object[] array) {
        String ret = "";
        for (int i = 0; i < array.length; ++i) {
            ret = ret + separator + array[i].toString();
        }
        return ret.isEmpty() ? "" : ret.substring(separator.length());
    }

    public static String join(String separator, Iterable iterable) {
        String ret = "";
        for (Object s2 : iterable) {
            ret = ret + separator + s2.toString();
        }
        return ret.isEmpty() ? "" : ret.substring(separator.length());
    }

    public static String joinCC(String separator, Object[] array) {
        String ret = "";
        for (int i = 0; i < array.length; ++i) {
            ret = ret + separator + Util.camelCase(array[i].toString());
        }
        return ret.isEmpty() ? "" : ret.substring(separator.length());
    }

    public static String joinCC(String separator, Iterable iterable) {
        String ret = "";
        for (Object s2 : iterable) {
            ret = ret + separator + Util.camelCase(s2.toString());
        }
        return ret.isEmpty() ? "" : ret.substring(separator.length());
    }

    public static void setTurtleUpgrade(ITurtleAccess turtle, TurtleSide side, ITurtleUpgrade upgrade) {
        Reflector.invoke(turtle, "set" + side.name() + "Upgrade", Object.class, upgrade);
    }

    public static aoh rayTraceBlock(ITurtleAccess turtle, int direction) {
        aoj pos = turtle.getPosition();
        int x = (int)pos.c + r.b[direction];
        int y = (int)pos.d + r.c[direction];
        int z = (int)pos.e + r.d[direction];
        return new aoh(x, y, z, ForgeDirection.getOrientation((int)direction).getOpposite().ordinal(), aoj.a((double)x, (double)y, (double)z));
    }

    public static aoh rayTraceBlock(ITurtleAccess turtle) {
        return Util.rayTraceBlock(turtle, turtle.getFacingDir());
    }

    public static int getUUID(ur stack) {
        return stack.j() * 32768 + stack.c ^ MiscPeripherals.instance.itemIDSeed;
    }

    public static int getUUID(LiquidStack stack) {
        return Util.getUUID(new ur(stack.itemID, stack.amount, stack.itemMeta));
    }

    public static aoh rayTrace(md ent, double d) {
        double dd2;
        if (ent == null) {
            return null;
        }
        double d1 = d;
        float f = 1.0f;
        aoh mop = Util.rayTrace(ent, d, f);
        aoj vec3d = Util.getPosition((lq)ent, f);
        if (mop != null) {
            d1 = mop.f.d(vec3d);
        }
        if (d1 > (dd2 = d)) {
            d1 = dd2;
        }
        d = d1;
        aoj vec3d1 = ent.i(f);
        aoj vec3d2 = vec3d.c(vec3d1.c * d, vec3d1.d * d, vec3d1.e * d);
        lq entity1 = null;
        float f1 = 1.0f;
        List list = ent.p.b((lq)ent, ent.D.a(vec3d1.c * d, vec3d1.d * d, vec3d1.e * d).b((double)f1, (double)f1, (double)f1));
        double d2 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d3;
            lq entity = (lq)list.get(i);
            if (!entity.L()) continue;
            float f2 = entity.Y();
            aoe axisalignedbb = entity.D.b((double)f2, (double)f2, (double)f2);
            aoh movingobjectposition = axisalignedbb.a(vec3d, vec3d2);
            if (axisalignedbb.a(vec3d)) {
                if (!(0.0 < d2) && d2 != 0.0) continue;
                entity1 = entity;
                d2 = 0.0;
                continue;
            }
            if (movingobjectposition == null || !((d3 = vec3d.d(movingobjectposition.f)) < d2) && d2 != 0.0) continue;
            entity1 = entity;
            d2 = d3;
        }
        if (entity1 != null) {
            mop = new aoh(entity1);
        }
        return mop;
    }

    public static aoh rayTrace(md ent, double par1, float par3) {
        aoj var4 = Util.getPosition((lq)ent, par3);
        aoj var5 = ent.i(par3);
        aoj var6 = var4.c(var5.c * par1, var5.d * par1, var5.e * par1);
        return ent.p.a(var4, var6);
    }

    public static aoj getPosition(lq ent, float par1) {
        if (par1 == 1.0f) {
            return ent.p.S().a(ent.t, ent.u + (double)ent.e(), ent.v);
        }
        double var2 = ent.q + (ent.t - ent.q) * (double)par1;
        double var4 = ent.r + (double)ent.e() + (ent.u - ent.r) * (double)par1;
        double var6 = ent.s + (ent.v - ent.s) * (double)par1;
        return ent.p.S().a(var2, var4, var6);
    }
}

